/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import org.jamocha.rete.Evaluate;
import org.jamocha.rete.Fact;

public class Binding
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected String varName = null;
    protected boolean isObjVar = false;
    protected boolean isPredJoin = false;
    protected int leftrow = -1;
    protected int leftIndex;
    protected int rightIndex;
    protected boolean negated = false;
    protected int rowDeclared = -1;

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String name) {
        this.varName = name;
    }

    public boolean getIsObjectVar() {
        return this.isObjVar;
    }

    public void setIsObjectVar(boolean obj) {
        this.isObjVar = obj;
    }

    public int rowDeclared() {
        return this.rowDeclared;
    }

    public void setRowDeclared(int row) {
        this.rowDeclared = row;
    }

    public int getLeftRow() {
        return this.leftrow;
    }

    public void setLeftRow(int left) {
        this.leftrow = left;
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public void setLeftIndex(int indx) {
        this.leftIndex = indx;
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    public void setRightIndex(int indx) {
        this.rightIndex = indx;
    }

    public boolean negated() {
        return this.negated;
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    public String toBindString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.leftrow + ")(");
        buf.append(this.leftIndex);
        if (this.negated) {
            buf.append(") not equal to (0)(");
        } else {
            buf.append(") equal to (0)(");
        }
        buf.append(this.rightIndex);
        buf.append(")");
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("?" + this.varName + " (" + this.leftrow + ")(");
        buf.append(this.leftIndex);
        if (this.negated) {
            buf.append(") not equal to (0)(");
        } else {
            buf.append(") equal to (0)(");
        }
        buf.append(this.rightIndex);
        buf.append(")");
        return buf.toString();
    }

    public Object clone() {
        Binding bind = new Binding();
        bind.setVarName(this.getVarName());
        bind.setIsObjectVar(this.getIsObjectVar());
        bind.setLeftRow(this.getLeftRow());
        bind.setLeftIndex(this.getLeftIndex());
        bind.setRightIndex(this.getRightIndex());
        return bind;
    }

    public boolean evaluate(Fact[] left, Fact right) {
        if (left[this.leftrow] == right) {
            return false;
        }
        if (this.negated) {
            return Evaluate.evaluateNotEqual(left[this.leftrow].getSlotValue(this.leftIndex), right.getSlotValue(this.rightIndex));
        }
        return Evaluate.evaluateEqual(left[this.leftrow].getSlotValue(this.leftIndex), right.getSlotValue(this.rightIndex));
    }

    public void setPredJoin(boolean isPredJoin) {
        this.isPredJoin = isPredJoin;
    }
}

