/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;

public class BetaMemoryImpl
implements BetaMemory {
    private static final long serialVersionUID = 1L;
    protected Index index = null;
    protected Map matches = null;

    public BetaMemoryImpl(Index index, Rete engine) {
        this.index = index;
        this.matches = engine.newMap();
    }

    public Index getIndex() {
        return this.index;
    }

    public Fact[] getLeftFacts() {
        return this.index.getFacts();
    }

    public Iterator iterateRightFacts() {
        return this.matches.keySet().iterator();
    }

    public boolean matched(Fact rightfact) {
        return this.matches.containsKey(rightfact);
    }

    public void addMatch(Fact rightfact) {
        this.matches.put(rightfact, null);
    }

    public void removeMatch(Fact rightfact) {
        this.matches.remove(rightfact);
    }

    public void clear() {
        this.matches.clear();
        this.index = null;
    }

    public int matchCount() {
        return this.matches.size();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < this.index.getFacts().length) {
            if (idx > 0) {
                buf.append(", ");
            }
            buf.append(this.index.getFacts()[idx].getFactId());
            ++idx;
        }
        buf.append(": ");
        for (Fact f : this.matches.keySet()) {
            buf.append(String.valueOf(f.getFactId()) + ", ");
        }
        return buf.toString();
    }
}

