/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.util.Map;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.Print;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;

public abstract class BaseNode
implements Serializable,
Print {
    protected int nodeID;
    protected BaseNode[] successorNodes = new BaseNode[0];
    protected int useCount = 0;

    public BaseNode(int id) {
        this.nodeID = id;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public Object[] getSuccessorNodes() {
        return this.successorNodes;
    }

    protected boolean containsNode(Object[] list, Object node) {
        boolean cn = false;
        int idx = 0;
        while (idx < list.length) {
            if (list[idx] == node) {
                cn = true;
                break;
            }
            ++idx;
        }
        return cn;
    }

    protected boolean addNode(BaseNode n) {
        boolean add = false;
        if (!this.containsNode(this.successorNodes, n)) {
            this.successorNodes = ConversionUtils.add(this.successorNodes, n);
            add = true;
        }
        return add;
    }

    public boolean removeNode(BaseNode n) {
        boolean rem = false;
        if (this.containsNode(this.successorNodes, n)) {
            this.successorNodes = ConversionUtils.remove(this.successorNodes, n);
            rem = true;
        }
        return rem;
    }

    public abstract void addSuccessorNode(BaseNode var1, Rete var2, WorkingMemory var3) throws AssertException;

    public abstract void removeAllSuccessors();

    public void clear(WorkingMemory mem) {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        leftmem.clear();
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getBetaRightMemory(this);
        rightmem.clear();
    }

    public int getNodeId() {
        return this.nodeID;
    }

    public void incrementUseCount() {
        ++this.useCount;
    }

    public void decrementUseCount() {
        --this.useCount;
    }

    public abstract String toString();

    public String hashString() {
        return "";
    }

    public abstract String toPPString();
}

