/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Map;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TerminalNode;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public abstract class BaseJoin
extends BaseNode {
    protected Binding[] binds = null;

    public BaseJoin(int id) {
        super(id);
    }

    public abstract void assertLeft(Index var1, Rete var2, WorkingMemory var3) throws AssertException;

    public abstract void assertRight(Fact var1, Rete var2, WorkingMemory var3) throws AssertException;

    public abstract void retractLeft(Index var1, Rete var2, WorkingMemory var3) throws RetractException;

    public abstract void retractRight(Fact var1, Rete var2, WorkingMemory var3) throws RetractException;

    public void setBindings(Binding[] binds) {
        this.binds = binds;
    }

    public void addSuccessorNode(BaseNode node, Rete engine, WorkingMemory mem) throws AssertException {
        if (node instanceof BaseJoin) {
            this.addSuccessorNode((BaseJoin)node, engine, mem);
        } else {
            this.addSuccessorNode((TerminalNode)node, engine, mem);
        }
    }

    public void addSuccessorNode(BaseJoin node, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.addNode(node)) {
            Map leftmem = (Map)mem.getBetaLeftMemory(this);
            for (BetaMemory betaMemory : leftmem.entrySet()) {
                Index left = betaMemory.getIndex();
                Map rightmem = (Map)mem.getBetaRightMemory(this);
                for (Fact rfcts : rightmem.keySet()) {
                    node.assertLeft(left.add(rfcts), engine, mem);
                }
            }
        }
    }

    public void addSuccessorNode(TerminalNode node, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.addNode(node)) {
            Map leftmem = (Map)mem.getBetaLeftMemory(this);
            for (Object omem : leftmem.values()) {
                if (!(omem instanceof BetaMemory)) continue;
                BetaMemory bmem = (BetaMemory)omem;
                Index left = bmem.getIndex();
                Map rightmem = (Map)mem.getBetaRightMemory(this);
                for (Fact rfcts : rightmem.keySet()) {
                    node.assertFacts(left.add(rfcts), engine, mem);
                }
            }
        }
    }

    public void removeAllSuccessors() {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            BaseNode bn = this.successorNodes[idx];
            bn.removeAllSuccessors();
            ++idx;
        }
        this.successorNodes = new BaseNode[0];
        this.useCount = 0;
    }

    protected void propogateAssert(Index inx, Rete engine, WorkingMemory mem) throws AssertException {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            BaseNode node = this.successorNodes[idx];
            if (node instanceof BaseJoin) {
                ((BaseJoin)node).assertLeft(inx, engine, mem);
            } else if (node instanceof TerminalNode) {
                ((TerminalNode)node).assertFacts(inx, engine, mem);
            }
            ++idx;
        }
    }

    protected void propogateRetract(Index inx, Rete engine, WorkingMemory mem) throws RetractException {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            BaseNode node = this.successorNodes[idx];
            if (node instanceof BaseJoin) {
                ((BaseJoin)node).retractLeft(inx, engine, mem);
            } else if (node instanceof TerminalNode) {
                ((TerminalNode)node).retractFacts(inx, engine, mem);
            }
            ++idx;
        }
    }
}

