/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.TerminalNode;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public abstract class BaseAlpha
extends BaseNode {
    private static final long serialVersionUID = 1L;
    protected int operator = 9;

    public BaseAlpha(int id) {
        super(id);
    }

    public abstract void assertFact(Fact var1, Rete var2, WorkingMemory var3) throws AssertException;

    public abstract void retractFact(Fact var1, Rete var2, WorkingMemory var3) throws RetractException;

    public int successorCount() {
        return this.successorNodes.length;
    }

    protected void propogateRetract(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            BaseNode next;
            BaseNode nNode = this.successorNodes[idx];
            if (nNode instanceof BaseAlpha) {
                next = (BaseAlpha)nNode;
                ((BaseAlpha)next).retractFact(fact, engine, mem);
            } else if (nNode instanceof BaseJoin) {
                next = (BaseJoin)nNode;
                ((BaseJoin)next).retractRight(fact, engine, mem);
            } else if (nNode instanceof TerminalNode) {
                Index inx = new Index(new Fact[]{fact});
                ((TerminalNode)nNode).retractFacts(inx, engine, mem);
            }
            ++idx;
        }
    }

    protected void propogateAssert(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            BaseNode next;
            BaseNode nNode = this.successorNodes[idx];
            if (nNode instanceof BaseAlpha) {
                next = (BaseAlpha)nNode;
                ((BaseAlpha)next).assertFact(fact, engine, mem);
            } else if (nNode instanceof BaseJoin) {
                next = (BaseJoin)nNode;
                ((BaseJoin)next).assertRight(fact, engine, mem);
            } else if (nNode instanceof TerminalNode) {
                next = (TerminalNode)nNode;
                Index inx = new Index(new Fact[]{fact});
                ((TerminalNode)next).assertFacts(inx, engine, mem);
            }
            ++idx;
        }
    }

    public void addSuccessorNode(BaseNode node, Rete engine, WorkingMemory mem) throws AssertException {
        AlphaMemory alpha;
        if (this.addNode(node) && (alpha = (AlphaMemory)mem.getAlphaMemory(this)).size() > 0) {
            Iterator itr = alpha.iterator();
            while (itr.hasNext()) {
                BaseNode next;
                if (node instanceof BaseAlpha) {
                    next = (BaseAlpha)node;
                    ((BaseAlpha)next).assertFact((Fact)itr.next(), engine, mem);
                    continue;
                }
                if (node instanceof BaseJoin) {
                    next = (BaseJoin)node;
                    ((BaseJoin)next).assertRight((Fact)itr.next(), engine, mem);
                    continue;
                }
                if (!(node instanceof TerminalNode)) continue;
                next = (TerminalNode)node;
                Index inx = new Index(new Fact[]{(Fact)itr.next()});
                ((TerminalNode)next).assertFacts(inx, engine, mem);
            }
        }
    }

    public void removeSuccessorNode(BaseNode node, Rete engine, WorkingMemory mem) throws RetractException {
        AlphaMemory alpha;
        if (this.removeNode(node) && (alpha = (AlphaMemory)mem.getAlphaMemory(this)).size() > 0) {
            Iterator itr = alpha.iterator();
            while (itr.hasNext()) {
                BaseNode next;
                if (node instanceof BaseAlpha) {
                    next = (BaseAlpha)node;
                    ((BaseAlpha)next).retractFact((Fact)itr.next(), engine, mem);
                    continue;
                }
                if (!(node instanceof BaseJoin)) continue;
                next = (BaseJoin)node;
                ((BaseJoin)next).retractRight((Fact)itr.next(), engine, mem);
            }
        }
    }

    public AlphaMemory getMemory(WorkingMemory mem) {
        return (AlphaMemory)mem.getAlphaMemory(this);
    }

    public void clear(WorkingMemory mem) {
        this.getMemory(mem).clear();
    }

    public int getOperator() {
        return this.operator;
    }

    public abstract String hashString();

    public abstract String toPPString();

    public abstract String toString();

    public void removeAllSuccessors() {
        int idx = 0;
        while (idx < this.successorNodes.length) {
            BaseNode bn = this.successorNodes[idx];
            bn.removeAllSuccessors();
            ++idx;
        }
        this.successorNodes = new BaseNode[0];
        this.useCount = 0;
    }
}

