/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.CompositeIndex;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnValue;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.Slot;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class AlphaNodePredConstr
extends BaseAlpha {
    private static final long serialVersionUID = 1L;
    protected Function function = null;
    protected String hashstring = null;
    protected Parameter[] params = null;
    protected Slot slot = null;
    protected CompositeIndex compIndex = null;

    public AlphaNodePredConstr(int id, Function func, Parameter[] params) {
        super(id);
        this.function = func;
        this.params = params;
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(fact, engine)) {
            AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
            alpha.addPartialMatch(fact);
            this.propogateAssert(fact, engine, mem);
        }
    }

    public void retractFact(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
        if (alpha.removePartialMatch(fact) != null) {
            this.propogateRetract(fact, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance, Rete engine) {
        int idx = 0;
        while (idx < this.params.length) {
            if (this.params[idx] instanceof BoundParam) {
                ((BoundParam)this.params[idx]).setFact(new Fact[]{factInstance});
            } else if (this.params[idx] instanceof FunctionParam2) {
                ((FunctionParam2)this.params[idx]).setFacts(new Fact[]{factInstance});
            }
            ++idx;
        }
        ReturnVector rv = this.function.executeFunction(engine, this.params);
        ReturnValue rval = rv.firstReturnValue();
        return rval.getBooleanValue();
    }

    public CompositeIndex getHashIndex() {
        if (this.compIndex == null) {
            this.compIndex = new CompositeIndex(this.slot.getName(), this.operator, this.slot.value);
        }
        return this.compIndex;
    }

    public String hashString() {
        if (this.hashstring == null) {
            this.hashstring = String.valueOf(this.slot.getId()) + ":" + this.operator + ":" + String.valueOf(this.slot.value);
        }
        return this.hashstring;
    }

    public String toString() {
        return "slot(" + this.slot.getId() + ") " + ConversionUtils.getPPOperator(this.operator) + " " + this.slot.value.toString() + " - useCount=" + this.useCount;
    }

    public String toPPString() {
        if (this.function != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("node-" + this.nodeID + "> slot(" + this.slot.getName() + ") ");
            buf.append(this.function.toPPString(this.params, 1));
            buf.append(" - useCount=" + this.useCount);
            return buf.toString();
        }
        return "node-" + this.nodeID + "> slot(" + this.slot.getName() + ") " + ConversionUtils.getPPOperator(this.operator) + " " + ConversionUtils.formatSlot(this.slot.value) + " - useCount=" + this.useCount;
    }
}

