/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.BaseAlpha2;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Slot2;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class AlphaNodeOr
extends BaseAlpha2 {
    private static final long serialVersionUID = 1L;
    protected Slot2 slot = null;
    protected int useCount = 0;

    public AlphaNodeOr(int id) {
        super(id);
    }

    public boolean isShared() {
        return this.useCount > 0;
    }

    public void setSlot(Slot sl) {
        this.slot = (Slot2)sl;
    }

    public void incrementUseCount() {
        ++this.useCount;
    }

    public void decrementUseCount() {
        --this.useCount;
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(fact)) {
            AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
            alpha.addPartialMatch(fact);
            this.propogateAssert(fact, engine, mem);
        }
    }

    public void retractFact(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
        if (alpha.removePartialMatch(fact) != null) {
            this.propogateRetract(fact, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance) {
        boolean not = this.slot.EvaluateNotList(factInstance.getSlotValue(this.slot.getId()));
        boolean eq = this.slot.getEqualList().contains(factInstance.getSlotValue(this.slot.getId()));
        return eq || not;
    }

    public void setOperator(int opr) {
    }

    public String hashString() {
        return this.toString();
    }

    public String toString() {
        return "slot(" + this.slot.getName() + ") " + this.slot.toString("|") + " - useCount=" + this.useCount;
    }

    public String toPPString() {
        return "or node-" + this.nodeID + "> slot(" + this.slot.getName() + ") " + this.slot.toString("|") + " - useCount=" + this.useCount;
    }
}

