/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.util.Iterator;
import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.BaseAlpha2;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Slot2;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class AlphaNodeAnd
extends BaseAlpha2 {
    private static final long serialVersionUID = 1L;
    protected Slot2 slot = null;
    protected int useCount = 0;

    public AlphaNodeAnd(int id) {
        super(id);
    }

    public boolean isShared() {
        return this.useCount > 0;
    }

    public void setSlot(Slot sl) {
        this.slot = (Slot2)sl;
    }

    public void incrementUseCount() {
        ++this.useCount;
    }

    public void decrementUseCount() {
        --this.useCount;
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(fact)) {
            AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
            alpha.addPartialMatch(fact);
            this.propogateAssert(fact, engine, mem);
        }
    }

    public void retractFact(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
        if (alpha.removePartialMatch(fact) != null) {
            this.propogateRetract(fact, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance) {
        boolean equal = true;
        Iterator itr = this.slot.getEqualList().iterator();
        Object fval = factInstance.getSlotValue(this.slot.getId());
        while (itr.hasNext()) {
            Object mv = itr.next();
            if (mv.equals(fval)) continue;
            equal = false;
            break;
        }
        if (equal) {
            for (Object mv : this.slot.getNotEqualList()) {
                if (!mv.equals(fval)) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public void setOperator(int opr) {
    }

    public String hashString() {
        return this.toString();
    }

    public String toString() {
        return "slot(" + this.slot.getName() + ") " + this.slot.toString("&") + " - useCount=" + this.useCount;
    }

    public String toPPString() {
        return "and node-" + this.nodeID + "> slot(" + this.slot.getName() + ") " + this.slot.toString("&") + " - useCount=" + this.useCount;
    }
}

