/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.BaseAlpha2;
import org.jamocha.rete.CompositeIndex;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Evaluate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class AlphaNode
extends BaseAlpha2 {
    private static final long serialVersionUID = 1L;
    protected Slot slot = null;
    protected String hashstring = null;
    protected CompositeIndex compIndex = null;

    public AlphaNode(int id) {
        super(id);
    }

    public void setOperator(int opr) {
        this.operator = opr;
    }

    public boolean isShared() {
        return this.useCount > 0;
    }

    public void setSlot(Slot sl) {
        this.slot = sl;
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(fact)) {
            AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
            alpha.addPartialMatch(fact);
            this.propogateAssert(fact, engine, mem);
        }
    }

    public void retractFact(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
        AlphaMemory alpha = (AlphaMemory)mem.getAlphaMemory(this);
        if (alpha.removePartialMatch(fact) != null) {
            this.propogateRetract(fact, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance) {
        return Evaluate.evaluate(this.operator, factInstance.getSlotValue(this.slot.getId()), this.slot.value);
    }

    public String toString() {
        return "slot(" + this.slot.getId() + ") " + ConversionUtils.getPPOperator(this.operator) + " " + this.slot.value.toString() + " - useCount=" + this.useCount;
    }

    public CompositeIndex getHashIndex() {
        if (this.compIndex == null) {
            this.compIndex = new CompositeIndex(this.slot.getName(), this.operator, this.slot.value);
        }
        return this.compIndex;
    }

    public String hashString() {
        if (this.hashstring == null) {
            this.hashstring = String.valueOf(this.slot.getId()) + ":" + this.operator + ":" + String.valueOf(this.slot.value);
        }
        return this.hashstring;
    }

    public String toPPString() {
        return "node-" + this.nodeID + "> slot(" + this.slot.getName() + ") " + ConversionUtils.getPPOperator(this.operator) + " " + ConversionUtils.formatSlot(this.slot.value) + " - useCount=" + this.useCount;
    }
}

