/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.util.Map;
import org.jamocha.rete.Activation;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Module;
import org.jamocha.rete.Rete;
import org.jamocha.rete.util.ProfileStats;

public class Agenda
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map modules = null;
    private Rete engine = null;
    private boolean watch = false;
    private boolean profAdd = false;
    private boolean profRm = false;
    private boolean startReset = false;

    public Agenda(Rete engine) {
        this.engine = engine;
        this.modules = engine.newLocalMap();
    }

    public void setWatch(boolean w) {
        this.watch = w;
    }

    public boolean watch() {
        return this.watch;
    }

    public void setProfileAdd(boolean prof) {
        this.profAdd = prof;
    }

    public boolean profileAdd() {
        return this.profAdd;
    }

    public void setProfileRemove(boolean prof) {
        this.profRm = prof;
    }

    public boolean profileRemove() {
        return this.profRm;
    }

    public void addActivation(Activation actv) {
        if (!this.startReset) {
            if (this.profAdd) {
                this.addActivationWProfile(actv);
            } else {
                if (this.watch) {
                    this.engine.writeMessage("=> " + actv.toPPString() + Constants.LINEBREAK, "t");
                }
                actv.getRule().getModule().addActivation(actv);
            }
        }
    }

    public void addActivationWProfile(Activation actv) {
        ProfileStats.startAddActivation();
        actv.getRule().getModule().addActivation(actv);
        ProfileStats.endAddActivation();
    }

    public void removeActivation(Activation actv) {
        if (this.profRm) {
            this.removeActivationWProfile(actv);
        } else {
            if (this.watch) {
                this.engine.writeMessage("<= " + actv.toPPString() + Constants.LINEBREAK, "t");
            }
            actv.getRule().getModule().removeActivation(actv);
        }
    }

    public void removeActivationWProfile(Activation actv) {
        ProfileStats.startRemoveActivation();
        actv.getRule().getModule().removeActivation(actv);
        ProfileStats.endRemoveActivation();
    }

    public void clear() {
        for (Object key : this.modules.keySet()) {
            Module mod = (Module)this.modules.get(key);
            mod.clear();
        }
        this.modules.clear();
    }

    public void startReset() {
        this.startReset = true;
    }

    public void endReset() {
        this.startReset = false;
    }
}

