/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public abstract class AbstractTemporalNode
extends BaseJoin {
    protected int leftElapsedTime = 0;
    protected int rightElapsedTime = 0;

    public AbstractTemporalNode(int id) {
        super(id);
    }

    public abstract void assertLeft(Index var1, Rete var2, WorkingMemory var3) throws AssertException;

    public abstract void assertRight(Fact var1, Rete var2, WorkingMemory var3) throws AssertException;

    public abstract void retractLeft(Index var1, Rete var2, WorkingMemory var3) throws RetractException;

    public abstract void retractRight(Fact var1, Rete var2, WorkingMemory var3) throws RetractException;

    public boolean evaluate(Fact[] leftlist, Fact right, long time) {
        boolean eval = true;
        if (leftlist[leftlist.length - 1].timeStamp() > time) {
            int idx = 0;
            while (idx < this.binds.length) {
                Binding bnd = this.binds[idx];
                eval = bnd.evaluate(leftlist, right);
                if (!eval) break;
                ++idx;
            }
            return eval;
        }
        return false;
    }

    protected long getRightTime() {
        long ts = System.currentTimeMillis();
        long time = this.rightElapsedTime > 0 ? ts - (long)this.rightElapsedTime : Long.MAX_VALUE;
        return time;
    }

    protected long getLeftTime() {
        long time = this.leftElapsedTime > 0 ? System.currentTimeMillis() - (long)this.leftElapsedTime : Long.MAX_VALUE;
        return time;
    }

    public abstract String toString();

    public abstract String toPPString();

    public int getLeftElapsedTime() {
        return this.leftElapsedTime;
    }

    public void setLeftElapsedTime(int leftElapsedTime) {
        this.leftElapsedTime = leftElapsedTime;
    }

    public int getRightElapsedTime() {
        return this.rightElapsedTime;
    }

    public void setRightElapsedTime(int rightElapsedTime) {
        this.rightElapsedTime = rightElapsedTime;
    }
}

