/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jamocha.rete.Parameter;

public abstract class AbstractParam
implements Parameter,
Serializable {
    protected boolean objBinding = false;

    public abstract int getValueType();

    public abstract Object getValue();

    public abstract void reset();

    public boolean isObjectBinding() {
        return this.objBinding;
    }

    public String getStringValue() {
        Object value = this.getValue();
        if (value != null) {
            return this.getValue().toString();
        }
        return "";
    }

    public boolean getBooleanValue() throws ClassCastException {
        if (this.getValue() != null && !(this.getValue() instanceof Boolean)) {
            Boolean b = new Boolean(this.getStringValue());
            return b;
        }
        return (Boolean)this.getValue();
    }

    public int getIntValue() throws NumberFormatException {
        if (this.getValue() != null && !(this.getValue() instanceof Number)) {
            throw new NumberFormatException("Value is not a number");
        }
        return ((Number)this.getValue()).intValue();
    }

    public short getShortValue() throws NumberFormatException {
        if (this.getValue() != null && !(this.getValue() instanceof Number)) {
            throw new NumberFormatException("Value is not a number");
        }
        return ((Number)this.getValue()).shortValue();
    }

    public long getLongValue() throws NumberFormatException {
        if (this.getValue() != null && !(this.getValue() instanceof Number)) {
            throw new NumberFormatException("Value is not a number");
        }
        return ((Number)this.getValue()).longValue();
    }

    public float getFloatValue() throws NumberFormatException {
        if (this.getValue() != null && !(this.getValue() instanceof Number)) {
            throw new NumberFormatException("Value is not a number");
        }
        return ((Number)this.getValue()).floatValue();
    }

    public double getDoubleValue() throws NumberFormatException {
        if (this.getValue() != null && !(this.getValue() instanceof Number)) {
            throw new NumberFormatException("Value is not a number");
        }
        return ((Number)this.getValue()).doubleValue();
    }

    public BigInteger getBigIntegerValue() throws NumberFormatException {
        if (this.getValue() != null && this.getValue() instanceof BigInteger) {
            return (BigInteger)this.getValue();
        }
        return new BigInteger(this.getValue().toString());
    }

    public BigDecimal getBigDecimalValue() throws NumberFormatException {
        if (this.getValue() != null && this.getValue() instanceof BigDecimal) {
            return (BigDecimal)this.getValue();
        }
        return new BigDecimal(this.getValue().toString());
    }
}

