/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.messaging;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.messaging.ContentHandler;
import org.jamocha.messaging.ContentHandlerRegistry;
import org.jamocha.messaging.MessageClient;
import org.jamocha.rete.Rete;

public class BasicClient
implements MessageClient {
    private static final long serialVersionUID = 1L;
    private Rete ENGINE = null;
    private Context CTX = null;
    private TopicConnection CONN = null;
    private Topic TOPIC = null;
    private TopicSession SESSION = null;
    private TopicSubscriber SUBSCRIBER = null;
    private TopicPublisher PUBLISHER = null;
    private String URL = null;
    private String JNDI = null;
    private String FACTORYNAME = null;
    private String USER = null;
    private String PASSWORD = null;
    private String TOPICNAME = null;
    private String CLIENTNAME = null;
    private Thread CLIENTTHREAD = null;
    protected Logger log = LogFactory.createLogger(BasicClient.class);

    public BasicClient() {
    }

    public BasicClient(String url, String initctxfactory, String factory, String topic, String user, String pwd, String name) {
        this.URL = url;
        this.JNDI = initctxfactory;
        this.FACTORYNAME = factory;
        this.USER = user;
        this.TOPICNAME = topic;
        this.PASSWORD = pwd;
        this.CLIENTNAME = name;
        this.init();
    }

    public void init() {
        Properties prop = new Properties();
        prop.put("java.naming.factory.initial", this.JNDI);
        prop.put("java.naming.provider.url", this.URL);
        prop.put("java.naming.security.principal", this.USER);
        prop.put("java.naming.security.credentials", this.PASSWORD);
        try {
            this.CTX = new InitialContext(prop);
        }
        catch (NamingException e) {
            this.log.warn(e);
        }
        this.connect();
        try {
            this.SESSION = this.CONN.createTopicSession(false, 1);
            if (this.TOPIC == null) {
                this.TOPIC = this.SESSION.createTopic(this.TOPICNAME);
            }
            this.SUBSCRIBER = this.SESSION.createSubscriber(this.TOPIC, null, true);
            this.SUBSCRIBER.setMessageListener((MessageListener)this);
            this.PUBLISHER = this.SESSION.createPublisher(this.TOPIC);
        }
        catch (JMSException e) {
            this.log.warn("error creating session, publisher and subscriber" + (Object)((Object)e));
        }
        this.start();
        while (!this.CLIENTTHREAD.isAlive()) {
        }
    }

    public void close() {
        try {
            try {
                this.PUBLISHER.close();
                this.SUBSCRIBER.close();
                this.SESSION.unsubscribe(this.TOPIC.getTopicName());
                this.SESSION.close();
                this.CONN.stop();
                this.CONN.close();
                this.CTX.close();
                this.SUBSCRIBER = null;
                this.PUBLISHER = null;
                this.CONN = null;
                this.TOPIC = null;
                this.ENGINE = null;
                this.CLIENTTHREAD.interrupt();
                this.CLIENTTHREAD = null;
            }
            catch (Exception e) {
                this.log.warn(e);
                try {
                    this.finalize();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                this.finalize();
            }
            catch (Throwable throwable) {}
        }
    }

    public void connect() {
        try {
            this.log.info("factoryname: " + this.FACTORYNAME);
            Object tcf = this.CTX.lookup(this.FACTORYNAME);
            TopicConnectionFactory factory = null;
            if (tcf != null) {
                factory = (TopicConnectionFactory)tcf;
            }
            this.CONN = factory.createTopicConnection();
            this.log.info("created TopicConnection");
            this.log.info("try to create topic " + this.TOPICNAME);
            this.TOPIC = (Topic)this.CTX.lookup(this.TOPICNAME);
            this.log.info("created topic " + this.TOPICNAME);
        }
        catch (JMSException e) {
            this.log.warn((Exception)((Object)e));
        }
        catch (NamingException e) {
            this.log.warn(e);
        }
        catch (Exception e) {
            this.log.warn(e);
        }
    }

    public String getConnectionFactory() {
        return this.FACTORYNAME;
    }

    public String getInitialContextFactory() {
        return this.JNDI;
    }

    public String getName() {
        return this.CLIENTNAME;
    }

    public String getProviderURL() {
        return this.URL;
    }

    public String getSecurityCredentials() {
        return this.PASSWORD;
    }

    public String getSecurityPrinciple() {
        return this.USER;
    }

    public String getTopic() {
        return this.TOPICNAME;
    }

    public void publish(Serializable message) {
        try {
            if (message instanceof String) {
                TextMessage resp = this.SESSION.createTextMessage((String)((Object)message));
                resp.setJMSType("text");
                this.PUBLISHER.publish((Message)resp);
            } else if (message instanceof ObjectMessage) {
                ((ObjectMessage)message).setJMSType("object");
                this.PUBLISHER.publish((Message)message);
            } else {
                ObjectMessage resp = this.SESSION.createObjectMessage(message);
                resp.setJMSType("text");
                this.PUBLISHER.publish((Message)resp);
            }
        }
        catch (JMSException e) {
            this.log.warn((Exception)((Object)e));
        }
    }

    public void publishObject(Object body) {
        try {
            if (body instanceof ObjectMessage) {
                this.PUBLISHER.publish((Message)body);
            } else {
                ObjectMessage resp = this.SESSION.createObjectMessage();
                resp.setObject((Serializable)body);
                this.PUBLISHER.publish((Message)resp);
            }
        }
        catch (JMSException e) {
            this.log.warn((Exception)((Object)e));
        }
    }

    public void setConnectionFactory(String name) {
        this.FACTORYNAME = name;
    }

    public void setInitialContextFactory(String ctxname) {
        this.JNDI = ctxname;
    }

    public void setName(String name) {
        this.CLIENTNAME = name;
    }

    public void setProviderURL(String url) {
        this.URL = url;
    }

    public void setSecurityCredentials(String pwd) {
        this.PASSWORD = pwd;
    }

    public void setSecurityPrinciple(String username) {
        this.USER = username;
    }

    public void setTopic(String topic) {
        this.TOPICNAME = topic;
    }

    public void setRete(Rete engine) {
        this.ENGINE = engine;
    }

    public void start() {
        try {
            this.CONN.start();
            this.CLIENTTHREAD = new Thread(this);
            this.CLIENTTHREAD.start();
        }
        catch (JMSException e) {
            this.log.warn((Exception)((Object)e));
        }
    }

    public void onMessage(Message msg) {
        try {
            if (msg != null && msg.getJMSType() != null) {
                ContentHandler handler = this.getHandler(msg);
                if (msg instanceof ObjectMessage && handler != null) {
                    ObjectMessage omsg = (ObjectMessage)msg;
                    handler.processMessage((Message)omsg, this.ENGINE, this);
                } else if (msg instanceof TextMessage && handler != null) {
                    TextMessage tmsg = (TextMessage)msg;
                    handler.processMessage((Message)tmsg, this.ENGINE, this);
                    this.log.info(tmsg.getText());
                }
            }
        }
        catch (JMSException e) {
            System.err.println("Communication error: " + e.getMessage());
        }
    }

    public void run() {
    }

    public ContentHandler getHandler(Message msg) {
        try {
            return ContentHandlerRegistry.findHandler(msg.getJMSType());
        }
        catch (JMSException e) {
            return null;
        }
    }
}

