/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.messagerouter;

import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.jamocha.messagerouter.AbstractCommunicationChannel;
import org.jamocha.messagerouter.InterestType;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.MessageRouter;
import org.jamocha.messagerouter.StringChannel;
import org.jamocha.parser.clips.CLIPSParser;
import org.jamocha.parser.clips.ParseException;
import org.jamocha.parser.clips.TokenMgrError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringChannelImpl
extends AbstractCommunicationChannel
implements StringChannel {
    private CLIPSParser parser;
    private List<MessageEvent> alreadyReceived = new LinkedList<MessageEvent>();

    public StringChannelImpl(String channelId, MessageRouter router, InterestType interest) {
        super(channelId, router, interest);
        this.parser = new CLIPSParser(router.getReteEngine(), null);
    }

    @Override
    public void executeCommand(String commandString) {
        this.executeCommand(commandString, false);
    }

    @Override
    public void executeCommand(String commandString, boolean blocked) {
        StringReader reader = new StringReader(commandString);
        LinkedList<MessageEvent> commandMessages = blocked ? new LinkedList<MessageEvent>() : null;
        this.parser.ReInit(reader);
        Object command = null;
        try {
            this.alreadyReceived.clear();
            while ((command = this.parser.basicExpr()) != null) {
                this.router.enqueueCommand(command, this.getChannelId());
                if (!blocked) continue;
                try {
                    while (blocked) {
                        MessageEvent lastMessage;
                        this.router.fillMessageList(this.getChannelId(), commandMessages);
                        int count = commandMessages.size();
                        if (count > 0 && ((lastMessage = (MessageEvent)commandMessages.get(count - 1)).getType() == 102 || lastMessage.getType() == -1)) {
                            this.alreadyReceived.addAll(commandMessages);
                            commandMessages.clear();
                            blocked = false;
                        }
                        if (!blocked) continue;
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException count) {
                    // empty catch block
                }
                blocked = true;
            }
        }
        catch (ParseException e) {
            this.router.postMessageEvent(new MessageEvent(2, e, this.getChannelId()));
        }
        catch (TokenMgrError e) {
            this.router.postMessageEvent(new MessageEvent(2, e, this.getChannelId()));
            this.parser.ReInit(reader);
        }
    }

    @Override
    public void fillEventList(List<MessageEvent> eventList) {
        eventList.addAll(this.alreadyReceived);
        super.fillEventList(eventList);
    }
}

