/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.messagerouter;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jamocha.messagerouter.AbstractCommunicationChannel;
import org.jamocha.messagerouter.InterestType;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.MessageRouter;
import org.jamocha.messagerouter.StreamChannel;
import org.jamocha.parser.clips.CLIPSParser;
import org.jamocha.parser.clips.ParseException;
import org.jamocha.parser.clips.TokenMgrError;

class StreamChannelImpl
extends AbstractCommunicationChannel
implements StreamChannel {
    private Reader reader;
    private CLIPSParser parser;
    private StreamChannelThread streamChannelThread;

    public void init(InputStream inputStream) {
        this.init(new InputStreamReader(inputStream));
    }

    public void init(Reader reader) {
        this.reader = reader;
        this.streamChannelThread.setStopped();
        this.streamChannelThread = new StreamChannelThread();
        this.parser.ReInit(reader);
        this.streamChannelThread.start();
    }

    void close() {
        this.streamChannelThread.setStopped();
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isAvailable() {
        return false;
    }

    public StreamChannelImpl(String channelId, MessageRouter router, InterestType interest) {
        super(channelId, router, interest);
        this.parser = new CLIPSParser(router.getReteEngine(), null);
        this.streamChannelThread = new StreamChannelThread();
    }

    public void executeCommand(String commandString) {
        Object command = null;
        try {
            while ((command = this.parser.basicExpr()) != null) {
                this.router.enqueueCommand(command, this.getChannelId());
            }
        }
        catch (ParseException e) {
            this.router.postMessageEvent(new MessageEvent(2, e, this.getChannelId()));
        }
    }

    private class StreamChannelThread
    extends Thread {
        private boolean stopped = false;

        private StreamChannelThread() {
        }

        public void run() {
            while (!this.stopped) {
                Object command = null;
                try {
                    while (!this.stopped && (command = StreamChannelImpl.this.parser.basicExpr()) != null) {
                        StreamChannelImpl.this.router.enqueueCommand(command, StreamChannelImpl.this.getChannelId());
                    }
                }
                catch (ParseException e) {
                    StreamChannelImpl.this.router.postMessageEvent(new MessageEvent(2, e, StreamChannelImpl.this.getChannelId()));
                    StreamChannelImpl.this.parser.ReInit(StreamChannelImpl.this.reader);
                }
                catch (TokenMgrError e) {
                    StreamChannelImpl.this.router.postMessageEvent(new MessageEvent(2, e, StreamChannelImpl.this.getChannelId()));
                    StreamChannelImpl.this.parser.ReInit(StreamChannelImpl.this.reader);
                }
            }
        }

        private void setStopped() {
            this.stopped = true;
        }
    }
}

