/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.messagerouter;

import java.util.ArrayList;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.MessageRouter;
import org.jamocha.messagerouter.StringChannel;
import org.jamocha.rete.Rete;

public class MessageRouterTest {
    public static void main(String[] args) {
        System.out.println("Started");
        Rete engine = new Rete();
        MessageRouter router = engine.getMessageRouter();
        StringChannel stringChannel = router.openChannel("TestChannel");
        long start = System.currentTimeMillis();
        stringChannel.executeCommand("(deftemplate wurst(slot name)(slot size))");
        ArrayList<MessageEvent> messages = new ArrayList<MessageEvent>();
        do {
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (message.isError()) {
                    System.err.println(message.getMessage());
                    continue;
                }
                System.out.println(message.getMessage());
            }
        } while (!messages.isEmpty());
        System.out.println(Runtime.getRuntime().maxMemory());
        int i = 1;
        while (i <= 100000) {
            start = System.currentTimeMillis();
            stringChannel.executeCommand("(assert (wurst(name salami" + i + ")(size 20)))");
            stringChannel.executeCommand("(+ 5 " + i + ")");
            System.out.println("-- elapsed time: " + (System.currentTimeMillis() - start) + "ms");
            if (i % 10000 == 0) {
                System.out.println(String.valueOf(i) + ": " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            }
            ++i;
        }
        stringChannel.executeCommand("(facts)");
        do {
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (message.isError()) {
                    System.err.println(message.getMessage());
                    continue;
                }
                System.out.println(message.getMessage());
            }
        } while (!messages.isEmpty());
        System.out.println("-- elapsed time: " + (System.currentTimeMillis() - start) + "ms");
    }
}

