/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.messagerouter;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jamocha.messagerouter.CLIPSInterpreter;
import org.jamocha.messagerouter.CommunicationChannel;
import org.jamocha.messagerouter.InterestType;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.StreamChannel;
import org.jamocha.messagerouter.StreamChannelImpl;
import org.jamocha.messagerouter.StringChannel;
import org.jamocha.messagerouter.StringChannelImpl;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRouter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, CommunicationChannel> idToChannel = new HashMap<String, CommunicationChannel>();
    private Map<String, List<MessageEvent>> idToMessages = new LinkedHashMap<String, List<MessageEvent>>();
    private volatile String currentChannelId = "";
    private Rete engine;
    private Queue<CommandObject> commandQueue = new LinkedList<CommandObject>();
    private Queue<MessageEvent> messageQueue = new LinkedList<MessageEvent>();
    private CLIPSInterpreter interpreter;
    private int idCounter = 0;
    private CommandThread commandThread;

    public MessageRouter(Rete engine) {
        this.engine = engine;
        this.interpreter = new CLIPSInterpreter(engine);
        this.commandThread = new CommandThread();
        this.commandThread.start();
    }

    public Rete getReteEngine() {
        return this.engine;
    }

    public void postMessageEvent(MessageEvent event) {
        this.messageQueue.offer(event);
    }

    public void enqueueCommand(Object command, String channelId) {
        this.commandQueue.add(new CommandObject(command, channelId));
    }

    public CommandObject dequeueCommand() {
        return this.commandQueue.poll();
    }

    public StreamChannel openChannel(String channelName, InputStream inputStream) {
        return this.openChannel(channelName, inputStream, InterestType.MINE);
    }

    public StreamChannel openChannel(String channelName, InputStream inputStream, InterestType interestType) {
        StreamChannelImpl channel = new StreamChannelImpl(String.valueOf(channelName) + "_" + this.idCounter++, this, interestType);
        channel.init(inputStream);
        this.registerChannel(channel);
        return channel;
    }

    public StreamChannel openChannel(String channelName, Reader reader) {
        return this.openChannel(channelName, reader, InterestType.MINE);
    }

    public StreamChannel openChannel(String channelName, Reader reader, InterestType interestType) {
        StreamChannelImpl channel = new StreamChannelImpl(String.valueOf(channelName) + "_" + this.idCounter++, this, interestType);
        channel.init(reader);
        this.registerChannel(channel);
        return channel;
    }

    public StringChannel openChannel(String channelName) {
        return this.openChannel(channelName, InterestType.MINE);
    }

    public StringChannel openChannel(String channelName, InterestType interestType) {
        StringChannelImpl channel = new StringChannelImpl(String.valueOf(channelName) + "_" + this.idCounter++, this, interestType);
        this.registerChannel(channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(CommunicationChannel channel) {
        Map<String, CommunicationChannel> map = this.idToChannel;
        synchronized (map) {
            this.idToChannel.remove(channel.getChannelId());
            this.idToMessages.remove(channel.getChannelId());
            if (channel instanceof StreamChannelImpl) {
                ((StreamChannelImpl)channel).close();
            }
        }
    }

    public void closeChannel(String channelName) {
        CommunicationChannel channel = this.idToChannel.get(channelName);
        if (channel instanceof StreamChannelImpl) {
            ((StreamChannelImpl)channel).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannel(CommunicationChannel channel) {
        Map<String, CommunicationChannel> map = this.idToChannel;
        synchronized (map) {
            this.idToChannel.put(channel.getChannelId(), channel);
            this.idToMessages.put(channel.getChannelId(), new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillMessageList(String channelId, List<MessageEvent> destinationList) {
        Map<String, CommunicationChannel> map = this.idToChannel;
        synchronized (map) {
            List<MessageEvent> storedMessages = this.idToMessages.get(channelId);
            if (storedMessages != null && destinationList != null) {
                destinationList.addAll(storedMessages);
                storedMessages.clear();
            }
        }
    }

    public void setCurrentChannelId(String id) {
        this.currentChannelId = id;
    }

    public String getCurrentChannelId() {
        if (this.currentChannelId == null) {
            this.currentChannelId = this.idToMessages.keySet().iterator().next();
        }
        return this.currentChannelId;
    }

    public final class CommandObject {
        private Object command;
        private String channelId;

        private CommandObject(Object command, String channelId) {
            this.command = command;
            this.channelId = channelId;
        }

        public Object getCommand() {
            return this.command;
        }
    }

    private final class CommandThread
    extends Thread {
        private CommandThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: while (true) {
                block16: {
                    if (MessageRouter.this.commandQueue.isEmpty()) {
                        try {
                            CommandThread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        CommandObject schabau = (CommandObject)MessageRouter.this.commandQueue.poll();
                        if (schabau != null) {
                            MessageRouter.this.currentChannelId = schabau.channelId;
                            try {
                                try {
                                    MessageRouter.this.messageQueue.offer(new MessageEvent(101, schabau.command, MessageRouter.this.currentChannelId));
                                    ReturnVector result = MessageRouter.this.interpreter.executeCommand(schabau.command);
                                    MessageRouter.this.messageQueue.offer(new MessageEvent(102, result, MessageRouter.this.currentChannelId));
                                }
                                catch (Exception e) {
                                    MessageRouter.this.postMessageEvent(new MessageEvent(-1, e, MessageRouter.this.currentChannelId));
                                    MessageRouter.this.currentChannelId = null;
                                    break block16;
                                }
                            }
                            catch (Throwable throwable) {
                                MessageRouter.this.currentChannelId = null;
                                throw throwable;
                            }
                            MessageRouter.this.currentChannelId = null;
                        }
                    }
                }
                ArrayList allMessages = new ArrayList(MessageRouter.this.messageQueue);
                MessageRouter.this.messageQueue.clear();
                int i = 0;
                while (true) {
                    if (i >= allMessages.size()) continue block9;
                    MessageEvent event = (MessageEvent)allMessages.get(i);
                    Map map = MessageRouter.this.idToChannel;
                    synchronized (map) {
                        for (CommunicationChannel channel : MessageRouter.this.idToChannel.values()) {
                            List messageList;
                            if (!InterestType.ALL.equals((Object)channel.getInterest()) && (!InterestType.MINE.equals((Object)channel.getInterest()) || !channel.getChannelId().equals(event.getChannelId())) || (messageList = (List)MessageRouter.this.idToMessages.get(channel.getChannelId())) == null) continue;
                            messageList.add(event);
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

