/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.messagerouter;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.MessageRouter;
import org.jamocha.messagerouter.StringChannel;
import org.jamocha.rete.Rete;

public class FunctionsViaMessageRouter
extends TestCase {
    public void test_assert() {
        System.out.println("");
        System.out.println("Start Assert");
        Rete engine = new Rete();
        MessageRouter router = engine.getMessageRouter();
        StringChannel stringChannel = router.openChannel("TestChannel");
        stringChannel.executeCommand("(deftemplate ass_tst(slot name)(slot size))");
        ArrayList<MessageEvent> messages = new ArrayList<MessageEvent>();
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Sleep Interrupted");
            }
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (!message.isError()) continue;
                System.err.println(message.getMessage());
            }
        } while (!messages.isEmpty());
        int loop = 10;
        int i = 1;
        while (i <= loop) {
            stringChannel.executeCommand("(assert(ass_tst(name tst" + i + ")(size " + i + ")))");
            Thread.yield();
            stringChannel.fillEventList(messages);
            messages.clear();
            ++i;
        }
        stringChannel.executeCommand("(facts)");
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Sleep Interrupted");
            }
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (message.isError()) {
                    System.err.println(message.getMessage());
                    continue;
                }
                String output = message.getMessage().toString();
                Pattern p = Pattern.compile("(for a total of )([0-9]+)", 2);
                Matcher m = p.matcher(output);
                while (m.find()) {
                    int facts = Integer.valueOf(m.group(2)) - 1;
                    System.out.println("Vergleich: Fakten in RuleML = " + facts + ", Fakten hinzugef\u00c3\u00bcgt = " + loop);
                    FunctionsViaMessageRouter.assertEquals((int)loop, (int)facts);
                }
            }
        } while (!messages.isEmpty());
        System.out.println("End Assert");
        System.out.println("");
    }

    public void test_deftemplate() {
        System.out.println("");
        System.out.println("Start Deftemplate");
        Rete engine = new Rete();
        MessageRouter router = engine.getMessageRouter();
        StringChannel stringChannel = router.openChannel("TestChannel");
        ArrayList<MessageEvent> messages = new ArrayList<MessageEvent>();
        int loop = 10;
        int i = 1;
        while (i <= loop) {
            stringChannel.executeCommand("(deftemplate tst" + i + "(slot name)(slot size))");
            Thread.yield();
            stringChannel.fillEventList(messages);
            messages.clear();
            ++i;
        }
        stringChannel.executeCommand("(templates)");
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Sleep Interrupted");
            }
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (message.isError()) {
                    System.err.println(message.getMessage());
                    continue;
                }
                String output = message.getMessage().toString();
                Pattern p = Pattern.compile("(for a total of )([0-9]+)", 2);
                Matcher m = p.matcher(output);
                while (m.find()) {
                    int facts = Integer.valueOf(m.group(2)) - 1;
                    System.out.println("Vergleich: Templates in RuleML = " + facts + ", Templates hinzugef\u00c3\u00bcgt = " + loop);
                    FunctionsViaMessageRouter.assertEquals((int)loop, (int)facts);
                }
            }
        } while (!messages.isEmpty());
        System.out.println("End Deftemplate");
        System.out.println("");
    }

    public void test_defrule() {
        System.out.println("");
        System.out.println("Start Defrule");
        Rete engine = new Rete();
        MessageRouter router = engine.getMessageRouter();
        StringChannel stringChannel = router.openChannel("TestChannel");
        ArrayList<MessageEvent> messages = new ArrayList<MessageEvent>();
        stringChannel.executeCommand("(deftemplate tst (slot name)(slot size))");
        int loop = 10;
        int i = 1;
        while (i <= loop) {
            String command = "(defrule tst" + i + " (tst) => (printout t \"Exists\" crlf))";
            stringChannel.executeCommand(command);
            Thread.yield();
            stringChannel.fillEventList(messages);
            messages.clear();
            ++i;
        }
        stringChannel.executeCommand("(rules)");
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Sleep Interrupted");
            }
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (message.isError()) {
                    System.err.println(message.getMessage());
                    continue;
                }
                String output = message.getMessage().toString();
                Pattern p = Pattern.compile("(for a total of )([0-9]+)", 2);
                Matcher m = p.matcher(output);
                while (m.find()) {
                    int facts = Integer.valueOf(m.group(2));
                    System.out.println("Vergleich: Regeln in RuleML = " + facts + ", Regeln hinzugef\u00c3\u00bcgt = " + loop);
                    FunctionsViaMessageRouter.assertEquals((int)loop, (int)facts);
                }
            }
        } while (!messages.isEmpty());
        System.out.println("End Defrule");
        System.out.println("");
    }

    public void test_fact_slots() {
        System.out.println("");
        System.out.println("Start DefFactSlots");
        Rete engine = new Rete();
        MessageRouter router = engine.getMessageRouter();
        StringChannel stringChannel = router.openChannel("TestChannel");
        ArrayList<MessageEvent> messages = new ArrayList<MessageEvent>();
        String command = "(deftemplate fa_sl_tst";
        int loop = 10;
        int i = 1;
        while (i <= loop) {
            command = String.valueOf(command) + "(slot tst" + i + ")";
            ++i;
        }
        command = String.valueOf(command) + ")";
        stringChannel.executeCommand(command);
        command = "(assert (fa_sl_tst";
        i = 1;
        while (i <= loop) {
            command = String.valueOf(command) + "(tst" + i + " " + i + ")";
            ++i;
        }
        command = String.valueOf(command) + "))";
        stringChannel.executeCommand(command);
        stringChannel.executeCommand("(facts)");
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Sleep Interrupted");
            }
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (message.isError()) {
                    System.err.println(message.getMessage());
                    continue;
                }
                String output = message.getMessage().toString();
                Pattern p = Pattern.compile("(for a total of )([0-9]+)", 2);
                Matcher m = p.matcher(output);
                while (m.find()) {
                    int facts = Integer.valueOf(m.group(2)) - 1;
                    System.out.println("Vergleich: Fakten mit " + loop + " slots in RuleML = " + facts + ", Fakten mit " + loop + " Slots hinzugef\u00c3\u00bcgt = 1");
                    FunctionsViaMessageRouter.assertEquals((int)1, (int)facts);
                }
            }
        } while (!messages.isEmpty());
        System.out.println("End DefFactSlots");
        System.out.println("");
    }

    public void test_rule_slots() {
        System.out.println("");
        System.out.println("Start TestRuleSlots");
        Rete engine = new Rete();
        MessageRouter router = engine.getMessageRouter();
        StringChannel stringChannel = router.openChannel("TestChannel");
        ArrayList<MessageEvent> messages = new ArrayList<MessageEvent>();
        int loop = 10;
        int i = 1;
        while (i <= loop) {
            stringChannel.executeCommand("(deftemplate ass_tst" + i + "(slot name)(slot size))");
            Thread.yield();
            stringChannel.fillEventList(messages);
            messages.clear();
            ++i;
        }
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Sleep Interrupted");
            }
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (!message.isError()) continue;
                System.err.println(message.getMessage());
            }
        } while (!messages.isEmpty());
        loop = 10;
        i = 1;
        while (i <= loop) {
            stringChannel.executeCommand("(assert(ass_tst" + i + "(name tst" + i + ")(size " + i + ")))");
            Thread.yield();
            stringChannel.fillEventList(messages);
            messages.clear();
            ++i;
        }
        String command = "(defrule rl_tst ";
        int i2 = 1;
        while (i2 <= loop) {
            command = String.valueOf(command) + "(ass_tst" + i2 + ") ";
            ++i2;
        }
        command = String.valueOf(command) + " => (printout t \"TEST\" crlf))";
        stringChannel.executeCommand(command);
        System.out.println(command);
        stringChannel.executeCommand("(rules)");
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Sleep Interrupted");
            }
            messages.clear();
            Thread.yield();
            stringChannel.fillEventList(messages);
            for (MessageEvent message : messages) {
                if (message.isError()) {
                    System.err.println(message.getMessage());
                    continue;
                }
                String output = message.getMessage().toString();
                Pattern p = Pattern.compile("(for a total of )([0-9]+)", 2);
                Matcher m = p.matcher(output);
                while (m.find()) {
                    int facts = Integer.valueOf(m.group(2));
                    System.out.println("Vergleich: Regeln mit " + loop + " facts in RuleML = " + facts + ", Regeln mit " + loop + " Facts hinzugef\u00c3\u00bcgt = 1");
                    FunctionsViaMessageRouter.assertEquals((int)1, (int)facts);
                }
            }
        } while (!messages.isEmpty());
        System.out.println("End TestRuleSlots");
        System.out.println("");
    }

    public static void main(String[] args) {
        FunctionsViaMessageRouter test = new FunctionsViaMessageRouter();
        int loop = 1;
        int idx = 0;
        while (idx < loop) {
            System.out.println("Start  Tests");
            System.out.println("------------ ");
            test.test_deftemplate();
            test.test_assert();
            test.test_defrule();
            test.test_fact_slots();
            test.test_rule_slots();
            System.out.println("------------ ");
            System.out.println("End Tests");
            ++idx;
        }
    }
}

