/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.logging;

import javax.servlet.ServletContext;
import org.apache.log4j.PropertyConfigurator;
import org.jamocha.logging.DefaultLogger;
import org.jamocha.logging.EmbeddedLogger;
import org.jamocha.logging.Logger;
import org.jamocha.logging.ServletLogger;

public class LogFactory {
    public static final int SERVLET = 1000;
    public static final int EMBEDDED = 2000;
    public static final int LOG4J = 3000;
    private static boolean configuredLog4J = false;
    private static int mode = 3000;
    private static ServletContext servletContext = null;

    public static Logger createLogger(Class clazz) {
        if (mode == 3000) {
            if (!configuredLog4J) {
                PropertyConfigurator.configure((String)"log4j.properties");
                configuredLog4J = true;
            }
            return new EmbeddedLogger(clazz);
        }
        if (mode == 1000) {
            return new ServletLogger(servletContext);
        }
        return new DefaultLogger();
    }

    public static void setServletContext(ServletContext context) {
        servletContext = context;
        mode = 1000;
    }

    public static boolean isConfiguredLog4J() {
        return configuredLog4J;
    }

    public static void setConfiguredLog4J(boolean configuredLog4J) {
        LogFactory.configuredLog4J = configuredLog4J;
    }
}

