/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui.tab.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jamocha.gui.JamochaGui;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.gui.tab.settings.AbstractSettingsPanel;

public class ShellSettingsPanel
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = -7136144663514250335L;
    private JComboBox fonts;
    private JComboBox fontsizes;
    private JButton fontColorChooserButton;
    private JTextField fontColorChooserPreview;
    private JButton backgroundColorChooserButton;
    private JTextField backgroundColorChooserPreview;

    public ShellSettingsPanel(JamochaGui gui) {
        super(gui);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        this.setLayout(gridbag);
        this.addLabel(this, new JLabel("Font:"), gridbag, c, 0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] allFonts = ge.getAllFonts();
        this.fonts = new JComboBox<Font>(allFonts);
        Font selFont = null;
        String selFontName = gui.getPreferences().get("shell.font", "Courier");
        Font[] fontArray = allFonts;
        int n = allFonts.length;
        int n2 = 0;
        while (n2 < n) {
            Font curFont = fontArray[n2];
            if (curFont.getFontName().equals(selFontName)) {
                selFont = curFont;
                break;
            }
            ++n2;
        }
        if (selFont != null) {
            this.fonts.setSelectedItem(selFont);
        }
        this.fonts.setRenderer(new FontListCellRenderer());
        this.addInputComponent(this, this.fonts, gridbag, c, 0);
        this.addLabel(this, new JLabel("Fontsize:"), gridbag, c, 1);
        Integer[] sizes = new Integer[17];
        int i = 0;
        while (i < sizes.length) {
            sizes[i] = 8 + i;
            ++i;
        }
        this.fontsizes = new JComboBox<Integer>(sizes);
        this.fontsizes.setSelectedItem(gui.getPreferences().getInt("shell.fontsize", 12));
        this.addInputComponent(this, this.fontsizes, gridbag, c, 1);
        this.addLabel(this, new JLabel("Fontcolor:"), gridbag, c, 2);
        JPanel fontColorChooserPanel = new JPanel(new FlowLayout());
        this.fontColorChooserPreview = new JTextField(5);
        this.fontColorChooserPreview.setEditable(false);
        this.fontColorChooserPreview.setBackground(new Color(gui.getPreferences().getInt("shell.fontcolor", Color.WHITE.getRGB())));
        this.fontColorChooserButton = new JButton("Choose Color", IconLoader.getImageIcon("color_swatch"));
        this.fontColorChooserButton.addActionListener(this);
        fontColorChooserPanel.add(this.fontColorChooserPreview);
        fontColorChooserPanel.add(this.fontColorChooserButton);
        this.addInputComponent(this, fontColorChooserPanel, gridbag, c, 2);
        this.addLabel(this, new JLabel("Backgroundcolor:"), gridbag, c, 3);
        JPanel backgroundColorChooserPanel = new JPanel(new FlowLayout());
        this.backgroundColorChooserPreview = new JTextField(5);
        this.backgroundColorChooserPreview.setEditable(false);
        this.backgroundColorChooserPreview.setBackground(new Color(gui.getPreferences().getInt("shell.backgroundcolor", Color.BLACK.getRGB())));
        this.backgroundColorChooserButton = new JButton("Choose Color", IconLoader.getImageIcon("color_swatch"));
        this.backgroundColorChooserButton.addActionListener(this);
        backgroundColorChooserPanel.add(this.backgroundColorChooserPreview);
        backgroundColorChooserPanel.add(this.backgroundColorChooserButton);
        this.addInputComponent(this, backgroundColorChooserPanel, gridbag, c, 3);
    }

    public void save() {
        this.gui.getPreferences().put("shell.font", ((Font)this.fonts.getSelectedItem()).getFontName());
        this.gui.getPreferences().putInt("shell.fontsize", (Integer)this.fontsizes.getSelectedItem());
        this.gui.getPreferences().putInt("shell.fontcolor", this.fontColorChooserPreview.getBackground().getRGB());
        this.gui.getPreferences().putInt("shell.backgroundcolor", this.backgroundColorChooserPreview.getBackground().getRGB());
    }

    public void actionPerformed(ActionEvent event) {
        Color newColor;
        if (event.getSource() == this.fontColorChooserButton) {
            Color newColor2 = JColorChooser.showDialog(this, "Choose a Fontcolor", new Color(this.gui.getPreferences().getInt("shell.fontcolor", Color.WHITE.getRGB())));
            if (newColor2 != null) {
                this.fontColorChooserPreview.setBackground(newColor2);
            }
        } else if (event.getSource() == this.backgroundColorChooserButton && (newColor = JColorChooser.showDialog(this, "Choose a Backgroundcolor", new Color(this.gui.getPreferences().getInt("shell.backgroundcolor", Color.BLACK.getRGB())))) != null) {
            this.backgroundColorChooserPreview.setBackground(newColor);
        }
    }

    private class FontListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setFont(((Font)value).deriveFont(12.0f));
            this.setText(((Font)value).getFontName());
            return this;
        }
    }
}

