/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jamocha.gui.JamochaGui;
import org.jamocha.gui.TableMap;
import org.jamocha.gui.TableSorter;
import org.jamocha.gui.editor.TemplateEditor;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.gui.tab.AbstractJamochaPanel;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Module;
import org.jamocha.rete.MultiSlot;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Template;

public class TemplatesPanel
extends AbstractJamochaPanel
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = -5732131176258158968L;
    private JSplitPane pane;
    private JTable templatesTable;
    private TemplatesTableModel dataModel;
    private JButton reloadButton;
    private JButton createNewButton;
    private JTextArea dumpArea;

    public TemplatesPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.dataModel = new TemplatesTableModel();
        TableSorter sorter = new TableSorter(new TableMap());
        ((TableMap)sorter.getModel()).setModel(this.dataModel);
        this.templatesTable = new JTable(sorter);
        sorter.addMouseListenerToHeaderInTable(this.templatesTable);
        this.templatesTable.setShowHorizontalLines(true);
        this.templatesTable.setRowSelectionAllowed(true);
        this.templatesTable.getTableHeader().setReorderingAllowed(false);
        this.templatesTable.getTableHeader().setToolTipText("Click to sort ascending. Click while pressing the shift-key down to sort descending");
        this.templatesTable.getSelectionModel().addListSelectionListener(this);
        this.dumpArea = new JTextArea();
        this.dumpArea.setLineWrap(true);
        this.dumpArea.setWrapStyleWord(true);
        this.dumpArea.setEditable(false);
        this.dumpArea.setFont(new Font("Courier", 0, 12));
        this.pane = new JSplitPane(0, new JScrollPane(this.templatesTable), new JScrollPane(this.dumpArea));
        this.add((Component)this.pane, "Center");
        this.pane.setDividerLocation(gui.getPreferences().getInt("facts.dividerlocation", 300));
        this.reloadButton = new JButton("Reload Templates", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButton.addActionListener(this);
        this.createNewButton = new JButton("Create new Template", IconLoader.getImageIcon("brick_add"));
        this.createNewButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.reloadButton);
        buttonPanel.add(this.createNewButton);
        this.add((Component)buttonPanel, "Last");
        this.initPopupMenu();
    }

    private void initTemplatesList() {
        this.dataModel.clear();
        Collection modules = this.gui.getEngine().getWorkingMemory().getModules();
        for (Module module : modules) {
            Collection templates = module.getTemplates();
            this.dataModel.addTemplates(templates, module);
        }
        this.templatesTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.templatesTable.getColumnModel().getColumn(1).setPreferredWidth(this.templatesTable.getWidth() - 100);
    }

    private void initPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem removeItem = new JMenuItem("Remove selected Template(s)", IconLoader.getImageIcon("brick_delete"));
        removeItem.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                int[] selCols = TemplatesPanel.this.templatesTable.getSelectedRows();
                int i = 0;
                while (i < selCols.length) {
                    String modName = (String)TemplatesPanel.this.dataModel.getValueAt(selCols[i], 0);
                    TemplatesPanel.this.gui.getEngine().getWorkingMemory().findModule(modName).removeTemplate(TemplatesPanel.this.dataModel.getRow(selCols[i]).getTemplate(), TemplatesPanel.this.gui.getEngine(), TemplatesPanel.this.gui.getEngine().getWorkingMemory());
                    ++i;
                }
                TemplatesPanel.this.initTemplatesList();
            }
        });
        menu.add(removeItem);
        this.templatesTable.setComponentPopupMenu(menu);
    }

    public void setFocus() {
        super.setFocus();
        this.initTemplatesList();
    }

    public void close() {
        this.gui.getPreferences().putInt("templates.dividerlocation", this.pane.getDividerLocation());
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.reloadButton)) {
            this.initTemplatesList();
        } else if (event.getSource().equals(this.createNewButton)) {
            TemplateEditor editor = new TemplateEditor(this.gui.getEngine());
            editor.setStringChannel(this.gui.getStringChannel());
            editor.init();
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.templatesTable.getSelectionModel()) {
            ExtTemplate template;
            StringBuilder buffer = new StringBuilder();
            if (this.templatesTable.getSelectedColumnCount() == 1 && this.templatesTable.getSelectedRow() > -1 && (template = this.dataModel.getRow(this.templatesTable.getSelectedRow())) != null) {
                Slot[] slots;
                buffer.append("(" + template.getModule().getModuleName() + "::" + template.getTemplate().getName());
                Slot[] slotArray = slots = (Slot[])template.getTemplate().getAllSlots();
                int n = slots.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot slot = slotArray[n2];
                    buffer.append("\n    (");
                    if (slot instanceof MultiSlot) {
                        buffer.append("multislot " + slot.getName() + ")");
                    } else {
                        buffer.append("slot " + slot.getName() + " (type " + ConversionUtils.getTypeName(slot.getValueType()) + ") )");
                    }
                    ++n2;
                }
                buffer.append("\n)");
            }
            this.dumpArea.setText(buffer.toString());
        }
    }

    private class ExtTemplate {
        private Template template;
        private Module module;

        private ExtTemplate(Template template, Module module) {
            this.template = template;
            this.module = module;
        }

        private Template getTemplate() {
            return this.template;
        }

        private Module getModule() {
            return this.module;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TemplatesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<ExtTemplate> templates = new LinkedList<ExtTemplate>();

        private TemplatesTableModel() {
        }

        private void clear() {
            this.templates = new LinkedList<ExtTemplate>();
            this.fireTableDataChanged();
        }

        private void addTemplates(Collection<Template> templates, Module module) {
            for (Template template : templates) {
                ExtTemplate exttemp = new ExtTemplate(template, module);
                this.templates.add(exttemp);
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Module";
                }
                case 1: {
                    return "Template";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int aColumn) {
            if (aColumn == 0) {
                return String.class;
            }
            if (aColumn == 1) {
                return String.class;
            }
            return Class.class;
        }

        @Override
        public int getRowCount() {
            return this.templates.size();
        }

        public ExtTemplate getRow(int row) {
            return this.templates.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            ExtTemplate template = this.getRow(row);
            switch (column) {
                case 0: {
                    return template.getModule().getModuleName();
                }
                case 1: {
                    return template.getTemplate().getName();
                }
            }
            return null;
        }
    }
}

