/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui.tab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import org.jamocha.gui.ClipboardUtil;
import org.jamocha.gui.JamochaGui;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.gui.tab.AbstractJamochaPanel;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.StreamChannel;
import org.jamocha.rete.Constants;

public class ShellPanel
extends AbstractJamochaPanel
implements ActionListener,
FocusListener,
AdjustmentListener {
    private static final long serialVersionUID = 1777454004380892575L;
    private boolean running = true;
    private Queue<KeyEvent> keyEventQueue = new ConcurrentLinkedQueue<KeyEvent>();
    private JTextArea outputArea;
    private JScrollPane scrollPane;
    private JButton clearButton;
    private int history_offset = 0;
    private final int history_max_size = 100;
    private List<String> history = new LinkedList<String>();
    private int lastPromptIndex = 0;
    private static final String SHELL_CURSOR = "_";
    private int cursorPosition = 0;
    private String cursorSubString = "";
    private Timer cursorTimer = new Timer(400, this);
    private boolean cursorShowing = false;
    private int lastScrollBarPosition = 0;
    private StreamChannel channel;
    private Writer outWriter;
    private StringBuilder lastIncompleteCommand = new StringBuilder();
    private Thread channelListener;

    public ShellPanel(JamochaGui gui) {
        super(gui);
        this.outputArea = new JTextArea();
        this.outputArea.setEditable(false);
        this.outputArea.setLineWrap(true);
        this.outputArea.setWrapStyleWord(true);
        this.outputArea.addFocusListener(this);
        this.settingsChanged();
        this.addFocusListener(this);
        this.scrollPane = new JScrollPane(this.outputArea, 20, 31);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.clearButton = new JButton("Clear Shell", IconLoader.getImageIcon("application_osx_terminal"));
        this.clearButton.addActionListener(this);
        JPanel clearButtonPanel = new JPanel();
        clearButtonPanel.setLayout(new FlowLayout(2, 5, 1));
        clearButtonPanel.add(this.clearButton);
        this.add((Component)clearButtonPanel, "Last");
        PipedOutputStream outStream = new PipedOutputStream();
        PipedInputStream inStream = new PipedInputStream();
        this.outWriter = new PrintWriter(outStream);
        try {
            inStream.connect(outStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.channel = gui.getEngine().getMessageRouter().openChannel("JamochaGui", inStream);
        this.printStartMessage();
        this.printPrompt();
        this.moveCursorToEnd();
        this.startTimer();
        this.initChannelListener();
        this.initKeyListener();
        this.initPopupMenu();
    }

    private synchronized void printStartMessage() {
        this.outputArea.append(String.valueOf(Constants.PROJECT_MESSAGE) + Constants.LINEBREAK);
        this.outputArea.append(String.valueOf(Constants.SHELL_MESSAGE) + Constants.LINEBREAK);
    }

    private synchronized void printPrompt() {
        this.outputArea.append(Constants.SHELL_PROMPT);
        this.lastPromptIndex = this.getOffset();
        this.outputArea.setCaretPosition(this.outputArea.getDocument().getLength());
    }

    private synchronized void printMessage(String message, boolean lineBreak) {
        if (lineBreak) {
            message = String.valueOf(message) + System.getProperty("line.separator");
        }
        this.outputArea.insert(message, this.cursorPosition);
        this.cursorPosition += message.length();
        if (lineBreak) {
            this.lastPromptIndex = this.getOffset();
        }
    }

    private synchronized void moveCursorToEnd() {
        this.moveCursorTo(this.getOffset());
    }

    private synchronized void moveCursorTo(int newPosition) {
        this.hideCursor();
        this.cursorPosition = newPosition;
        this.showCursor();
    }

    private synchronized void showCursor() {
        if (!this.cursorShowing) {
            int currOffset = this.getOffset();
            if (currOffset >= this.cursorPosition + SHELL_CURSOR.length()) {
                try {
                    this.cursorSubString = this.outputArea.getText(this.cursorPosition, SHELL_CURSOR.length());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                this.outputArea.replaceRange(SHELL_CURSOR, this.cursorPosition, this.cursorPosition + this.cursorSubString.length());
            } else {
                int offset = currOffset - this.cursorPosition;
                if (offset < 0) {
                    offset = 0;
                }
                try {
                    this.cursorSubString = this.outputArea.getText(this.cursorPosition, offset);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                this.outputArea.replaceRange(SHELL_CURSOR, this.cursorPosition, this.cursorPosition + offset);
            }
        }
        this.cursorShowing = true;
    }

    private synchronized void hideCursor() {
        if (this.cursorShowing) {
            try {
                this.outputArea.replaceRange(this.cursorSubString, this.cursorPosition, this.cursorPosition + SHELL_CURSOR.length());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cursorShowing = false;
    }

    private synchronized void removeCharLeft() {
        this.outputArea.replaceRange("", this.cursorPosition - 1, this.cursorPosition);
        --this.cursorPosition;
    }

    private synchronized void removeCharRight() {
        this.outputArea.replaceRange("", this.cursorPosition, this.cursorPosition + 1);
    }

    private synchronized void removeLine() {
        this.outputArea.replaceRange("", this.lastPromptIndex, this.getOffset());
        this.cursorPosition = this.getOffset();
    }

    private synchronized void startTimer() {
        if (!this.cursorTimer.isRunning()) {
            this.cursorTimer.start();
        }
    }

    private synchronized void stopTimer() {
        this.cursorTimer.stop();
    }

    private void initChannelListener() {
        this.channelListener = new Thread(){

            public void run() {
                ArrayList<MessageEvent> msgEvents = new ArrayList<MessageEvent>();
                boolean printPrompt = false;
                while (ShellPanel.this.running) {
                    ShellPanel.this.channel.fillEventList(msgEvents);
                    if (!msgEvents.isEmpty()) {
                        ShellPanel.this.stopTimer();
                        StringBuilder buffer = new StringBuilder();
                        for (MessageEvent event : msgEvents) {
                            if (event.getType() == 2 || event.getType() == -1 || event.getType() == 102) {
                                printPrompt = true;
                                ShellPanel.this.lastIncompleteCommand = new StringBuilder();
                            }
                            if (event.getType() == -1) {
                                buffer.append(String.valueOf(this.exceptionToString((Exception)event.getMessage()).trim()) + System.getProperty("line.separator"));
                            }
                            if (event.getType() == 101 || event.getMessage().toString().equals("") || event.getMessage().equals("nil")) continue;
                            buffer.append(String.valueOf(event.getMessage().toString().trim()) + System.getProperty("line.separator"));
                        }
                        msgEvents.clear();
                        ShellPanel.this.hideCursor();
                        ShellPanel.this.printMessage(buffer.toString().trim(), true);
                        if (printPrompt) {
                            ShellPanel.this.printPrompt();
                            ShellPanel.this.moveCursorTo(ShellPanel.this.lastPromptIndex);
                        }
                        ShellPanel.this.showCursor();
                        printPrompt = false;
                        ShellPanel.this.startTimer();
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException buffer) {
                        // empty catch block
                    }
                }
                try {
                    ShellPanel.this.outWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ShellPanel.this.gui.getEngine().getMessageRouter().closeChannel(ShellPanel.this.channel);
            }

            private String exceptionToString(Exception exception) {
                StringBuilder res = new StringBuilder();
                StackTraceElement[] str = exception.getStackTrace();
                int i = 0;
                while (i < str.length) {
                    res.append(str[i] + System.getProperty("line.separator"));
                    ++i;
                }
                return res.toString();
            }
        };
        this.channelListener.start();
    }

    private void initKeyListener() {
        KeyAdapter adapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ShellPanel.this.keyEventQueue.offer(e);
                e.consume();
            }
        };
        this.addKeyListener(adapter);
        this.outputArea.addKeyListener(adapter);
        Thread eventThread = new Thread(){

            public void run() {
                while (ShellPanel.this.running) {
                    if (!ShellPanel.this.keyEventQueue.isEmpty()) {
                        KeyEvent e = (KeyEvent)ShellPanel.this.keyEventQueue.poll();
                        int delta = 1;
                        switch (e.getKeyCode()) {
                            case 40: 
                            case 225: {
                                delta = -1;
                            }
                            case 38: 
                            case 224: {
                                ShellPanel.this.stopTimer();
                                ShellPanel.this.hideCursor();
                                ShellPanel shellPanel = ShellPanel.this;
                                shellPanel.history_offset = shellPanel.history_offset + delta;
                                if (ShellPanel.this.history_offset <= 0) {
                                    ShellPanel.this.history_offset = 0;
                                    if (ShellPanel.this.lastPromptIndex < ShellPanel.this.getOffset()) {
                                        ShellPanel.this.removeLine();
                                    }
                                } else {
                                    int index;
                                    if (ShellPanel.this.history_offset > ShellPanel.this.history.size()) {
                                        ShellPanel.this.history_offset = ShellPanel.this.history.size();
                                    }
                                    if (ShellPanel.this.lastPromptIndex < ShellPanel.this.getOffset()) {
                                        ShellPanel.this.removeLine();
                                    }
                                    if ((index = ShellPanel.this.history.size() - ShellPanel.this.history_offset) >= 0 && ShellPanel.this.history.size() > 0) {
                                        String tmp = (String)ShellPanel.this.history.get(index);
                                        ShellPanel.this.printMessage(tmp, false);
                                    }
                                }
                                ShellPanel.this.moveCursorToEnd();
                                ShellPanel.this.startTimer();
                                break;
                            }
                            case 10: {
                                ShellPanel.this.stopTimer();
                                ShellPanel.this.hideCursor();
                                if (ShellPanel.this.lastPromptIndex < ShellPanel.this.getOffset()) {
                                    String currLine = "";
                                    try {
                                        try {
                                            currLine = ShellPanel.this.outputArea.getText(ShellPanel.this.lastPromptIndex, ShellPanel.this.getOffset() - ShellPanel.this.lastPromptIndex);
                                        }
                                        catch (BadLocationException e1) {
                                            e1.printStackTrace();
                                        }
                                        ShellPanel.this.lastIncompleteCommand.append(String.valueOf(currLine) + System.getProperty("line.separator"));
                                        if (currLine.length() > 0) {
                                            ShellPanel.this.addToHistory(currLine);
                                            ShellPanel.this.outWriter.write(currLine);
                                            ShellPanel.this.outWriter.flush();
                                        }
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                ShellPanel.this.printMessage("", true);
                                ShellPanel.this.moveCursorToEnd();
                                ShellPanel.this.startTimer();
                                break;
                            }
                            case 8: {
                                ShellPanel.this.stopTimer();
                                ShellPanel.this.hideCursor();
                                if (ShellPanel.this.cursorPosition > ShellPanel.this.lastPromptIndex) {
                                    ShellPanel.this.removeCharLeft();
                                }
                                ShellPanel.this.showCursor();
                                ShellPanel.this.startTimer();
                                break;
                            }
                            case 127: {
                                ShellPanel.this.stopTimer();
                                ShellPanel.this.hideCursor();
                                if (ShellPanel.this.cursorPosition < ShellPanel.this.getOffset()) {
                                    ShellPanel.this.removeCharRight();
                                }
                                ShellPanel.this.showCursor();
                                ShellPanel.this.startTimer();
                                break;
                            }
                            case 39: 
                            case 227: {
                                if (e.isShiftDown()) break;
                                ShellPanel.this.stopTimer();
                                ShellPanel.this.hideCursor();
                                if (ShellPanel.this.cursorPosition < ShellPanel.this.getOffset()) {
                                    ShellPanel.this.moveCursorTo(ShellPanel.this.cursorPosition + 1);
                                }
                                ShellPanel.this.showCursor();
                                ShellPanel.this.startTimer();
                                break;
                            }
                            case 37: 
                            case 226: {
                                if (e.isShiftDown()) break;
                                ShellPanel.this.stopTimer();
                                ShellPanel.this.hideCursor();
                                if (ShellPanel.this.cursorPosition > ShellPanel.this.lastPromptIndex) {
                                    ShellPanel.this.moveCursorTo(ShellPanel.this.cursorPosition - 1);
                                }
                                ShellPanel.this.showCursor();
                                ShellPanel.this.startTimer();
                                break;
                            }
                            case 16: 
                            case 17: 
                            case 18: 
                            case 157: {
                                break;
                            }
                            default: {
                                if (!e.isControlDown() && !e.isMetaDown()) {
                                    ShellPanel.this.printMessage(String.valueOf(e.getKeyChar()), false);
                                    break;
                                }
                                if (e.getKeyChar() == 'v' || e.getKeyCode() == 86) {
                                    String clipContent = ClipboardUtil.getInstance().getClipboardContents();
                                    if (clipContent == null) break;
                                    ShellPanel.this.printMessage(clipContent, false);
                                    break;
                                }
                                if (e.getKeyChar() != 'c' && e.getKeyCode() != 67) break;
                                ClipboardUtil.getInstance().setClipboardContents(ShellPanel.this.outputArea.getSelectedText());
                            }
                        }
                        ShellPanel.this.startTimer();
                        continue;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        eventThread.start();
    }

    private void addToHistory(String historyString) {
        String[] lines = historyString.split(System.getProperty("line.separator"));
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].equals("")) {
                this.history.add(lines[i]);
            }
            ++i;
        }
        while (this.history.size() > 100) {
            this.history.remove(0);
        }
        this.history_offset = 0;
    }

    private void initPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem copyMenu = new JMenuItem("Copy", IconLoader.getImageIcon("page_copy"));
        copyMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ClipboardUtil.getInstance().setClipboardContents(ShellPanel.this.outputArea.getSelectedText());
            }
        });
        JMenuItem pasteMenu = new JMenuItem("Paste", IconLoader.getImageIcon("paste_plain"));
        pasteMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                String clipContent = ClipboardUtil.getInstance().getClipboardContents();
                if (clipContent != null) {
                    ShellPanel.this.printMessage(clipContent, false);
                }
            }
        });
        JMenuItem selectCommandMenu = new JMenuItem("Select current line");
        selectCommandMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ShellPanel.this.outputArea.setSelectionStart(ShellPanel.this.lastPromptIndex);
                ShellPanel.this.outputArea.setSelectionEnd(ShellPanel.this.getOffset());
            }
        });
        JMenuItem selectAllMenu = new JMenuItem("Select all");
        selectAllMenu.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                ShellPanel.this.outputArea.setSelectionStart(0);
                ShellPanel.this.outputArea.setSelectionEnd(ShellPanel.this.getOffset());
            }
        });
        menu.add(copyMenu);
        menu.add(pasteMenu);
        menu.addSeparator();
        menu.add(selectCommandMenu);
        menu.add(selectAllMenu);
        this.outputArea.setComponentPopupMenu(menu);
    }

    private synchronized void clearArea() {
        this.stopTimer();
        this.hideCursor();
        this.outputArea.setText("");
        this.lastPromptIndex = 0;
        this.cursorPosition = 0;
        this.lastScrollBarPosition = 0;
        if (this.lastIncompleteCommand.length() > 0) {
            this.printPrompt();
            this.cursorPosition = this.getOffset();
            this.printMessage(this.lastIncompleteCommand.toString().trim(), true);
        } else {
            this.printPrompt();
        }
        this.moveCursorToEnd();
        this.setFocus();
        this.startTimer();
    }

    private synchronized int getOffset() {
        try {
            return this.outputArea.getLineEndOffset(this.outputArea.getLineCount() - 1);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public void setFocus() {
        super.setFocus();
    }

    public void close() {
        this.stopTimer();
        this.running = false;
    }

    public void settingsChanged() {
        this.outputArea.setFont(new Font(this.gui.getPreferences().get("shell.font", "Courier"), this.gui.getPreferences().getInt("shell.fontstyle", 0), this.gui.getPreferences().getInt("shell.fontsize", 12)));
        this.outputArea.setBackground(new Color(this.gui.getPreferences().getInt("shell.backgroundcolor", Color.BLACK.getRGB())));
        this.outputArea.setForeground(new Color(this.gui.getPreferences().getInt("shell.fontcolor", Color.WHITE.getRGB())));
        this.outputArea.setBorder(BorderFactory.createLineBorder(this.outputArea.getBackground(), 2));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.clearButton)) {
            this.clearArea();
        } else if (event.getSource().equals(this.cursorTimer)) {
            if (this.cursorShowing) {
                this.hideCursor();
            } else {
                this.showCursor();
            }
        }
    }

    public void focusGained(FocusEvent event) {
        if (event.getSource() == this || event.getSource() == this.outputArea) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ShellPanel.this.showCursor();
                    ShellPanel.this.startTimer();
                }
            });
        }
    }

    public void focusLost(FocusEvent event) {
        if (event.getSource() == this || event.getSource() == this.outputArea) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ShellPanel.this.stopTimer();
                    ShellPanel.this.hideCursor();
                }
            });
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        if (event.getValue() < this.lastScrollBarPosition) {
            this.stopTimer();
        } else {
            this.lastScrollBarPosition = event.getValue();
            this.startTimer();
        }
    }
}

