/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jamocha.gui.JamochaGui;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.gui.tab.AbstractJamochaPanel;
import org.jamocha.gui.tab.settings.AbstractSettingsPanel;
import org.jamocha.gui.tab.settings.EngineSettingsPanel;
import org.jamocha.gui.tab.settings.ShellSettingsPanel;

public class SettingsPanel
extends AbstractJamochaPanel
implements ActionListener {
    private static final long serialVersionUID = 1934727733895902279L;
    private JTabbedPane tabbedPane;
    private JButton saveButton;
    private List<AbstractSettingsPanel> panels = new LinkedList<AbstractSettingsPanel>();

    public SettingsPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        EngineSettingsPanel engineSettingsPanel = new EngineSettingsPanel(gui);
        this.tabbedPane.addTab("Engine", null, engineSettingsPanel, "Engine Settings");
        this.panels.add(engineSettingsPanel);
        ShellSettingsPanel shellSettingsPanel = new ShellSettingsPanel(gui);
        this.tabbedPane.addTab("Shell", null, shellSettingsPanel, "Shell Settings");
        this.panels.add(shellSettingsPanel);
        this.add((Component)this.tabbedPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 1));
        this.saveButton = new JButton("Save Changes", IconLoader.getImageIcon("disk"));
        this.saveButton.addActionListener(this);
        buttonPanel.add(this.saveButton);
        this.add((Component)buttonPanel, "South");
    }

    public void close() {
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.saveButton) {
            for (AbstractSettingsPanel panel : this.panels) {
                panel.save();
            }
            this.gui.settingsChanged();
            try {
                this.gui.getPreferences().flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }
}

