/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui.tab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jamocha.gui.JamochaGui;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.gui.tab.AbstractJamochaPanel;
import org.jamocha.messagerouter.InterestType;
import org.jamocha.messagerouter.MessageEvent;
import org.jamocha.messagerouter.StringChannel;
import org.jamocha.rete.Function;

public class LogPanel
extends AbstractJamochaPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 4811690181744862051L;
    private JSplitPane pane;
    private JTextArea detailView;
    private JTable logTable;
    private JButton clearButton;
    private LogTableModel dataModel = new LogTableModel();
    private LogTableCellRenderer cellRenderer;
    private StringChannel logChannel;
    private boolean running = true;

    public LogPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.logChannel = gui.getEngine().getMessageRouter().openChannel("gui_log", InterestType.ALL);
        this.detailView = new JTextArea();
        this.detailView.setEditable(false);
        this.detailView.setFont(new Font("Courier", 0, 12));
        this.cellRenderer = new LogTableCellRenderer();
        this.logTable = new JTable(this.dataModel){
            private static final long serialVersionUID = 1L;

            public TableCellRenderer getCellRenderer(int row, int column) {
                return LogPanel.this.cellRenderer;
            }
        };
        this.logTable.setSelectionMode(0);
        this.logTable.getSelectionModel().addListSelectionListener(this);
        this.pane = new JSplitPane(0, new JScrollPane(this.logTable), new JScrollPane(this.detailView));
        this.pane.setDividerLocation(gui.getPreferences().getInt("log.dividerlocation", 300));
        this.add((Component)this.pane, "Center");
        Thread logThread = new Thread(){

            public void run() {
                LinkedList<MessageEvent> msgEvents = new LinkedList<MessageEvent>();
                while (LogPanel.this.running) {
                    LogPanel.this.logChannel.fillEventList(msgEvents);
                    if (!msgEvents.isEmpty()) {
                        LogPanel.this.dataModel.addEvents(msgEvents);
                        msgEvents.clear();
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                LogPanel.this.gui.getEngine().getMessageRouter().closeChannel(LogPanel.this.logChannel);
            }
        };
        logThread.start();
        this.clearButton = new JButton("Clear Log", IconLoader.getImageIcon("monitor"));
        this.clearButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.clearButton);
        this.add((Component)buttonPanel, "Last");
    }

    public void close() {
        this.running = false;
        this.gui.getPreferences().putInt("log.dividerlocation", this.pane.getDividerLocation());
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.clearButton) {
            this.dataModel.clearEvents();
            this.detailView.setText("");
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.logTable.getSelectionModel()) {
            StringBuilder buffer = new StringBuilder();
            if (this.logTable.getSelectedRow() > -1) {
                LogMessageEvent event = this.dataModel.getRow(this.logTable.getSelectedRow());
                buffer.append("Date-Time:    " + event.getDatetimeFormatted() + "\nChannel:      " + event.getChannelId() + "\nMessage-Type: " + event.getTypeFormatted() + "\n\nMessage:\n========\n");
                Object message = event.getMessage();
                if (message instanceof Exception) {
                    Exception ex = (Exception)message;
                    StackTraceElement[] str = ex.getStackTrace();
                    buffer.append(String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage());
                    StackTraceElement[] stackTraceElementArray = str;
                    int n = str.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement strelem = stackTraceElementArray[n2];
                        buffer.append("\n" + strelem);
                        ++n2;
                    }
                } else if (message instanceof Function) {
                    buffer.append("(" + ((Function)message).getName() + ")");
                } else {
                    buffer.append(message.toString());
                }
            }
            this.detailView.setText(buffer.toString());
        }
    }

    private final class LogMessageEvent
    extends MessageEvent {
        private static final long serialVersionUID = -5690784906495393031L;
        private Calendar datetime;
        private String typeFormatted;
        private int superType;
        public static final int TYPE_EVENT = 1;
        public static final int TYPE_WARNING = 2;
        public static final int TYPE_ERROR = 3;

        public LogMessageEvent(MessageEvent event) {
            this(event.getType(), event.getMessage(), event.getChannelId());
        }

        public LogMessageEvent(int type, Object message, String channelId) {
            super(type, message, channelId);
            this.datetime = Calendar.getInstance();
            switch (type) {
                case 11: {
                    this.typeFormatted = "ERROR: Error adding node";
                    this.superType = 3;
                    break;
                }
                case 0: {
                    this.typeFormatted = "EVENT: added Rule";
                    this.superType = 1;
                    break;
                }
                case 6: {
                    this.typeFormatted = "ERROR: Error in CLIPSParser";
                    this.superType = 3;
                    break;
                }
                case 8: {
                    this.typeFormatted = "EVENT: CLIPSParser reinitialized";
                    this.superType = 1;
                    break;
                }
                case 7: {
                    this.typeFormatted = "WARNING: CLIPSParser-Warning";
                    this.superType = 2;
                    break;
                }
                case 101: {
                    this.typeFormatted = "EVENT: incoming Command";
                    this.superType = 1;
                    break;
                }
                case 103: {
                    this.typeFormatted = "EVENT: Engine-Message";
                    this.superType = 1;
                    break;
                }
                case -1: {
                    this.typeFormatted = "ERROR: unspecified Error";
                    this.superType = 3;
                    break;
                }
                case 10: {
                    this.typeFormatted = "WARNING: invalid Function";
                    this.superType = 2;
                    break;
                }
                case 9: {
                    this.typeFormatted = "WARNING: Function not found";
                    this.superType = 2;
                    break;
                }
                case 3: {
                    this.typeFormatted = "WARNING: invalid Rule";
                    this.superType = 2;
                    break;
                }
                case 2: {
                    this.typeFormatted = "ERROR: Parse-Error";
                    this.superType = 3;
                    break;
                }
                case 1: {
                    this.typeFormatted = "EVENT: Rule removed";
                    this.superType = 1;
                    break;
                }
                case 102: {
                    this.typeFormatted = "EVENT: returned result";
                    this.superType = 1;
                    break;
                }
                case 4: {
                    this.typeFormatted = "EVENT: Rule exists";
                    this.superType = 1;
                    break;
                }
                case 5: {
                    this.typeFormatted = "WARNING: Template not found";
                    this.superType = 2;
                    break;
                }
                default: {
                    this.typeFormatted = "Unknown Messagetype";
                    this.superType = 1;
                }
            }
        }

        public int getSuperType() {
            return this.superType;
        }

        public String getDatetimeFormatted() {
            StringBuilder res = new StringBuilder();
            res.append(String.valueOf(this.datetime.get(1)) + "/");
            res.append(String.valueOf(this.datetime.get(2) + 1 > 9 ? "" : "0") + (this.datetime.get(2) + 1) + "/");
            res.append(String.valueOf(this.datetime.get(5) > 9 ? "" : "0") + this.datetime.get(5) + " - ");
            res.append(String.valueOf(this.datetime.get(11) > 9 ? "" : "0") + this.datetime.get(11) + ":");
            res.append(String.valueOf(this.datetime.get(12) > 9 ? "" : "0") + this.datetime.get(12) + ":");
            res.append(String.valueOf(this.datetime.get(13) > 9 ? "" : "0") + this.datetime.get(13));
            return res.toString();
        }

        public String getTypeFormatted() {
            return this.typeFormatted;
        }
    }

    private final class LogTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -6649805279420707106L;
        private Color colorError = Color.RED;
        private Color colorWarning = Color.ORANGE;
        private Color colorEvent = Color.BLUE;

        private LogTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent returnComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            switch (((LogTableModel)table.getModel()).getRow(row).getSuperType()) {
                case 3: {
                    this.setForeground(this.colorError);
                    break;
                }
                case 2: {
                    this.setForeground(this.colorWarning);
                    break;
                }
                default: {
                    this.setForeground(this.colorEvent);
                }
            }
            return returnComponent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LogTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<LogMessageEvent> events = new LinkedList<LogMessageEvent>();
        private int maxEventCount = 1000;

        private LogTableModel() {
        }

        private void addEvents(List<MessageEvent> events) {
            LogPanel.this.logTable.getColumnModel().getColumn(0).setPreferredWidth(180);
            LogPanel.this.logTable.getColumnModel().getColumn(1).setPreferredWidth(100);
            LogPanel.this.logTable.getColumnModel().getColumn(2).setPreferredWidth(LogPanel.this.logTable.getWidth() - 280);
            for (MessageEvent event : events) {
                this.events.add(new LogMessageEvent(event));
            }
            while (this.events.size() > this.maxEventCount) {
                this.events.remove(0);
            }
            this.fireTableDataChanged();
        }

        private void clearEvents() {
            this.events.clear();
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Date - Time";
                }
                case 1: {
                    return "Channel";
                }
                case 2: {
                    return "Message-Type";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int aColumn) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.events.size();
        }

        public LogMessageEvent getRow(int row) {
            return this.events.get(this.events.size() - (row + 1));
        }

        @Override
        public Object getValueAt(int row, int column) {
            LogMessageEvent event = this.getRow(row);
            if (event != null) {
                switch (column) {
                    case 0: {
                        return event.getDatetimeFormatted();
                    }
                    case 1: {
                        return event.getChannelId();
                    }
                    case 2: {
                        return event.getTypeFormatted();
                    }
                }
            }
            return null;
        }
    }
}

