/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jamocha.gui.JamochaGui;
import org.jamocha.gui.TableMap;
import org.jamocha.gui.TableSorter;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.gui.tab.AbstractJamochaPanel;
import org.jamocha.messagerouter.StringChannel;
import org.jamocha.rete.Function;

public class FunctionsPanel
extends AbstractJamochaPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 23L;
    private JTextArea dumpAreaFunction;
    private JSplitPane pane;
    private JTable functionsTable;
    private FunctionsTableModel dataModel;
    private StringChannel editorChannel;
    private JButton reloadButton;

    public FunctionsPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.dataModel = new FunctionsTableModel();
        TableSorter sorter = new TableSorter(new TableMap());
        ((TableMap)sorter.getModel()).setModel(this.dataModel);
        this.functionsTable = new JTable(sorter);
        sorter.addMouseListenerToHeaderInTable(this.functionsTable);
        this.functionsTable.setShowHorizontalLines(false);
        this.functionsTable.setRowSelectionAllowed(true);
        this.functionsTable.getTableHeader().setReorderingAllowed(false);
        this.functionsTable.getTableHeader().setToolTipText("Click to sort ascending. Click while pressing the shift-key down to sort descending");
        this.functionsTable.getSelectionModel().addListSelectionListener(this);
        this.dumpAreaFunction = new JTextArea();
        this.dumpAreaFunction.setLineWrap(true);
        this.dumpAreaFunction.setWrapStyleWord(true);
        this.dumpAreaFunction.setEditable(false);
        this.dumpAreaFunction.setFont(new Font("Courier", 0, 12));
        this.pane = new JSplitPane(0, new JScrollPane(this.functionsTable), new JScrollPane(this.dumpAreaFunction));
        this.add((Component)this.pane, "Center");
        this.pane.setDividerLocation(gui.getPreferences().getInt("functions.dividerlocation", 300));
        this.reloadButton = new JButton("Reload Functions", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.reloadButton);
        this.add((Component)buttonPanel, "Last");
        this.initFunctionsList();
    }

    private void initFunctionsList() {
        Collection c = this.gui.getEngine().getAllFunctions();
        Function[] func = c.toArray(new Function[0]);
        ArrayList<Function> funcs = new ArrayList<Function>();
        boolean larger = false;
        funcs.add(0, func[0]);
        int idx = 1;
        while (idx <= func.length - 1) {
            int bound = funcs.size();
            larger = true;
            int indx = 0;
            while (indx < bound) {
                int cmpvalue = func[idx].getName().compareTo(((Function)funcs.get(indx)).getName());
                if (cmpvalue < 0) {
                    funcs.add(indx, func[idx]);
                    indx = bound;
                    larger = false;
                } else if (cmpvalue == 0) {
                    indx = bound;
                    larger = false;
                }
                ++indx;
            }
            if (larger) {
                funcs.add(func[idx]);
            }
            ++idx;
        }
        this.dataModel.setFunctions(funcs);
        this.functionsTable.getColumnModel().getColumn(0).setPreferredWidth(50);
    }

    public void setFocus() {
        super.setFocus();
        this.initFunctionsList();
    }

    public void close() {
        if (this.editorChannel != null) {
            this.gui.getEngine().getMessageRouter().closeChannel(this.editorChannel);
        }
        this.gui.getPreferences().putInt("functions.dividerlocation", this.pane.getDividerLocation());
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.reloadButton)) {
            this.initFunctionsList();
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.functionsTable.getSelectionModel()) {
            Function function;
            StringBuilder buffer = new StringBuilder();
            if (this.functionsTable.getSelectedColumnCount() == 1 && this.functionsTable.getSelectedRow() > -1 && (function = this.dataModel.getRow(this.functionsTable.getSelectedRow())) != null) {
                buffer.append(function.toPPString(null, 0));
                buffer.append("\n");
            }
            this.dumpAreaFunction.setText(buffer.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FunctionsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<Function> funclist = Collections.emptyList();

        private FunctionsTableModel() {
        }

        private void setFunctions(List<Function> funclist) {
            this.funclist = funclist;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Functions";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int aColumn) {
            if (aColumn == 0) {
                return String.class;
            }
            return Class.class;
        }

        @Override
        public int getRowCount() {
            return this.funclist.size();
        }

        public Function getRow(int row) {
            return this.funclist.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            String functionname = this.getRow(row).getName();
            return functionname;
        }
    }
}

