/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jamocha.gui.JamochaGui;
import org.jamocha.gui.TableMap;
import org.jamocha.gui.TableSorter;
import org.jamocha.gui.editor.FactEditor;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.gui.tab.AbstractJamochaPanel;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.Fact;
import org.jamocha.rete.MultiSlot;
import org.jamocha.rete.exception.RetractException;

public class FactsPanel
extends AbstractJamochaPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -5732131176258158968L;
    private JSplitPane pane;
    private JTable factsTable;
    private FactsTableModel dataModel;
    private JButton reloadButton;
    private JButton assertButton;
    private JTextArea dumpArea;

    public FactsPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.dataModel = new FactsTableModel();
        TableSorter sorter = new TableSorter(new TableMap());
        ((TableMap)sorter.getModel()).setModel(this.dataModel);
        this.factsTable = new JTable(sorter);
        sorter.addMouseListenerToHeaderInTable(this.factsTable);
        this.factsTable.setShowHorizontalLines(true);
        this.factsTable.setRowSelectionAllowed(true);
        this.factsTable.getTableHeader().setReorderingAllowed(false);
        this.factsTable.getTableHeader().setToolTipText("Click to sort ascending. Click while pressing the shift-key down to sort descending");
        this.factsTable.getSelectionModel().addListSelectionListener(this);
        this.dumpArea = new JTextArea();
        this.dumpArea.setLineWrap(true);
        this.dumpArea.setWrapStyleWord(true);
        this.dumpArea.setEditable(false);
        this.dumpArea.setFont(new Font("Courier", 0, 12));
        this.pane = new JSplitPane(0, new JScrollPane(this.factsTable), new JScrollPane(this.dumpArea));
        this.add((Component)this.pane, "Center");
        this.pane.setDividerLocation(gui.getPreferences().getInt("facts.dividerlocation", 300));
        this.reloadButton = new JButton("Reload Facts", IconLoader.getImageIcon("database_refresh"));
        this.reloadButton.addActionListener(this);
        this.assertButton = new JButton("Assert Fact", IconLoader.getImageIcon("database_add"));
        this.assertButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.reloadButton);
        buttonPanel.add(this.assertButton);
        this.add((Component)buttonPanel, "Last");
        this.initPopupMenu();
    }

    private void initFactsList() {
        List facts = this.gui.getEngine().getAllFacts();
        this.dataModel.setFacts(facts);
        this.factsTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.factsTable.getColumnModel().getColumn(1).setPreferredWidth(this.factsTable.getWidth() - 50);
    }

    private void initPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem retractItem = new JMenuItem("Retract selected Fact(s)", IconLoader.getImageIcon("database_delete"));
        retractItem.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                int[] selCols = FactsPanel.this.factsTable.getSelectedRows();
                int i = 0;
                while (i < selCols.length) {
                    Long value = (Long)FactsPanel.this.dataModel.getValueAt(selCols[i], 0);
                    try {
                        FactsPanel.this.gui.getEngine().retractById(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (RetractException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                FactsPanel.this.initFactsList();
            }
        });
        menu.add(retractItem);
        this.factsTable.setComponentPopupMenu(menu);
    }

    public void setFocus() {
        super.setFocus();
        this.initFactsList();
    }

    public void close() {
        this.gui.getPreferences().putInt("facts.dividerlocation", this.pane.getDividerLocation());
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.reloadButton)) {
            this.initFactsList();
        } else if (event.getSource().equals(this.assertButton)) {
            FactEditor editor = new FactEditor(this.gui.getEngine());
            editor.setStringChannel(this.gui.getStringChannel());
            editor.init();
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.factsTable.getSelectionModel()) {
            Fact fact;
            StringBuilder buffer = new StringBuilder();
            if (this.factsTable.getSelectedColumnCount() == 1 && this.factsTable.getSelectedRow() > -1 && (fact = this.dataModel.getRow(this.factsTable.getSelectedRow())) != null) {
                BaseSlot[] slots;
                buffer.append("f-" + fact.getFactId() + "(" + fact.getDeftemplate().getName());
                BaseSlot[] baseSlotArray = slots = fact.getDeftemplate().getAllSlots();
                int n = slots.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseSlot slot = baseSlotArray[n2];
                    buffer.append("\n    (" + slot.getName() + " ");
                    if (slot.getValueType() == 10) {
                        MultiSlot ms = (MultiSlot)slot;
                        int i = 0;
                        while (i < ms.getValue().length) {
                            if (i > 0) {
                                buffer.append(" ");
                            }
                            buffer.append(ms.getValue()[i].toString());
                            ++i;
                        }
                    } else {
                        String value = fact.getSlotValue(slot.getId()).toString();
                        if (!value.equals("")) {
                            buffer.append(value);
                        }
                    }
                    buffer.append(")");
                    ++n2;
                }
                buffer.append("\n)");
            }
            this.dumpArea.setText(buffer.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FactsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<Fact> facts = Collections.emptyList();

        private FactsTableModel() {
        }

        private void setFacts(List<Fact> facts) {
            this.facts = facts;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "Fact";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int aColumn) {
            if (aColumn == 0) {
                return Number.class;
            }
            if (aColumn == 1) {
                return String.class;
            }
            return Class.class;
        }

        @Override
        public int getRowCount() {
            return this.facts.size();
        }

        public Fact getRow(int row) {
            return this.facts.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            Fact fact = this.getRow(row);
            switch (column) {
                case 0: {
                    return fact.getFactId();
                }
                case 1: {
                    return fact.toFactString();
                }
            }
            return null;
        }
    }
}

