/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jamocha.gui.editor.AbstractJamochaEditor;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.messagerouter.StringChannel;
import org.jamocha.rete.Module;
import org.jamocha.rete.MultiSlot;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Template;

public class FactEditor
extends AbstractJamochaEditor
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 6037731034903564707L;
    private int step = 0;
    private JPanel contentPanel;
    private JButton cancelButton;
    private JButton assertButton;
    private JButton backButton;
    private JButton nextButton;
    private JButton reloadButtondumpAreaFact;
    private JList moduleList;
    private JList templateList;
    private JTextArea dumpAreaTemplate = new JTextArea();
    private JTextArea dumpAreaFact = new JTextArea();
    private DefaultListModel moduleListModel = new DefaultListModel();
    private DefaultListModel templateListModel = new DefaultListModel();
    private StringChannel channel;
    private Map<Slot, JComponent> factComponents = new HashMap<Slot, JComponent>();

    public FactEditor(Rete engine) {
        super(engine);
        this.setLayout(new BorderLayout());
        this.setTitle("Assert new Fact");
        this.contentPanel = new JPanel(new CardLayout());
        this.add((Component)this.contentPanel, "Center");
        this.cancelButton = new JButton("Cancel", IconLoader.getImageIcon("cancel"));
        this.cancelButton.addActionListener(this);
        this.assertButton = new JButton("Assert Fact", IconLoader.getImageIcon("database_add"));
        this.assertButton.addActionListener(this);
        this.assertButton.setVisible(false);
        this.backButton = new JButton("Back", IconLoader.getImageIcon("resultset_previous"));
        this.backButton.addActionListener(this);
        this.backButton.setVisible(false);
        this.nextButton = new JButton("Next", IconLoader.getImageIcon("resultset_next"));
        this.nextButton.setHorizontalTextPosition(2);
        this.nextButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 5, 1));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.backButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.assertButton);
        this.add((Component)buttonPanel, "Last");
        this.dumpAreaTemplate.setEditable(false);
        this.dumpAreaTemplate.setFont(new Font("Courier", 0, 12));
        this.dumpAreaTemplate.setRows(5);
        this.dumpAreaFact.setEditable(false);
        this.dumpAreaFact.setFont(new Font("Courier", 0, 12));
        this.dumpAreaFact.setRows(5);
    }

    public void setStringChannel(StringChannel channel) {
        this.channel = channel;
    }

    public void init() {
        this.initPreselectionPanel();
        this.initFactEditPanel();
        this.showCurrentStep();
        this.setVisible(true);
    }

    private void initPreselectionPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel preselectionPanel = new JPanel(gridbag);
        preselectionPanel.setBorder(BorderFactory.createTitledBorder("Module and Template Selection"));
        c.fill = 1;
        this.moduleList = new JList(this.moduleListModel);
        this.moduleList.setSelectionMode(0);
        this.moduleList.getSelectionModel().addListSelectionListener(this);
        Collection modules = this.engine.getWorkingMemory().getModules();
        for (Object obj : modules) {
            Module mod = (Module)obj;
            this.moduleListModel.addElement(mod.getModuleName());
        }
        JPanel modulePanel = new JPanel();
        modulePanel.setLayout(new BoxLayout(modulePanel, 1));
        modulePanel.add(new JLabel("Select a Module:"));
        modulePanel.add(new JScrollPane(this.moduleList));
        c.weightx = 0.5;
        c.gridy = 0;
        c.gridx = 0;
        c.weighty = 1.0;
        gridbag.setConstraints(modulePanel, c);
        preselectionPanel.add(modulePanel);
        this.templateList = new JList(this.templateListModel);
        this.templateList.setSelectionMode(0);
        this.templateList.getSelectionModel().addListSelectionListener(this);
        this.initTemplateList();
        JPanel templatePanel = new JPanel();
        templatePanel.setLayout(new BoxLayout(templatePanel, 1));
        templatePanel.add(new JLabel("Select a Template:"));
        templatePanel.add(new JScrollPane(this.templateList));
        c.gridx = 1;
        gridbag.setConstraints(templatePanel, c);
        preselectionPanel.add(templatePanel);
        JPanel dumpAreaPanel = new JPanel();
        dumpAreaPanel.setLayout(new BoxLayout(dumpAreaPanel, 1));
        dumpAreaPanel.add(new JLabel("Template Definition:"));
        dumpAreaPanel.add(new JScrollPane(this.dumpAreaTemplate));
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        gridbag.setConstraints(dumpAreaPanel, c);
        preselectionPanel.add(dumpAreaPanel);
        this.contentPanel.add((Component)preselectionPanel, "preselection");
    }

    private void initTemplateList() {
        this.templateListModel.clear();
        Module module = this.engine.getWorkingMemory().findModule(String.valueOf(this.moduleList.getSelectedValue()));
        if (module != null) {
            Collection templates = module.getTemplates();
            for (Object obj : templates) {
                Template tmp = (Template)obj;
                if (module.getModuleName().equals("MAIN") && tmp.getName().equals("_initialFact")) continue;
                this.templateListModel.addElement(tmp.getName());
            }
        }
    }

    private void initFactEditPanel() {
        this.factComponents.clear();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel factEditPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(gridbag);
        factEditPanel.setBorder(BorderFactory.createTitledBorder("Set the Slots for the Fact"));
        if (this.templateList.getSelectedIndex() > -1) {
            Module module = this.engine.getWorkingMemory().findModule(String.valueOf(this.moduleList.getSelectedValue()));
            Template tmp = module.getTemplate(String.valueOf(this.templateList.getSelectedValue()));
            c.weightx = 1.0;
            Slot[] slots = (Slot[])tmp.getAllSlots();
            int i = 0;
            while (i < slots.length) {
                c.gridx = 0;
                c.gridy = i;
                c.fill = 3;
                c.anchor = 13;
                JLabel label = new JLabel(String.valueOf(slots[i].getName()) + ": ");
                gridbag.setConstraints(label, c);
                innerPanel.add(label);
                c.gridx = 1;
                c.fill = 1;
                c.anchor = 17;
                if (slots[i] instanceof MultiSlot) {
                    MultiSlotEditor multislotEditor = new MultiSlotEditor();
                    JScrollPane scrollPane = new JScrollPane(multislotEditor.getList());
                    gridbag.setConstraints(scrollPane, c);
                    innerPanel.add(scrollPane);
                    this.factComponents.put(slots[i], multislotEditor.getList());
                } else if (slots[i].getValueType() == 13) {
                    JComboBox factBox = new JComboBox();
                    this.factComponents.put(slots[i], factBox);
                } else {
                    JTextField textField = new JTextField();
                    gridbag.setConstraints(textField, c);
                    innerPanel.add(textField);
                    this.factComponents.put(slots[i], textField);
                }
                ++i;
            }
        }
        factEditPanel.add((Component)new JScrollPane(innerPanel), "Center");
        JPanel dumpAreaPanel = new JPanel();
        dumpAreaPanel.setLayout(new BoxLayout(dumpAreaPanel, 1));
        dumpAreaPanel.add(new JLabel("Fact Preview:"));
        dumpAreaPanel.add(new JScrollPane(this.dumpAreaFact));
        this.reloadButtondumpAreaFact = new JButton("Reload Fact Preview", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButtondumpAreaFact.addActionListener(this);
        dumpAreaPanel.add(this.reloadButtondumpAreaFact);
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        gridbag.setConstraints(dumpAreaPanel, c);
        factEditPanel.add((Component)dumpAreaPanel, "South");
        this.contentPanel.add("factEdit", factEditPanel);
    }

    private void showCurrentStep() {
        switch (this.step) {
            case 0: {
                ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "preselection");
                if (this.templateList.getSelectedIndex() > -1) {
                    this.nextButton.setEnabled(true);
                } else {
                    this.nextButton.setEnabled(false);
                }
                this.nextButton.setVisible(true);
                this.backButton.setVisible(false);
                this.assertButton.setVisible(false);
                this.nextButton.requestFocus();
                break;
            }
            case 1: {
                this.initFactEditPanel();
                ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "factEdit");
                this.nextButton.setVisible(false);
                this.backButton.setVisible(true);
                this.assertButton.setVisible(true);
                this.assertButton.requestFocus();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.assertButton) {
            this.channel.executeCommand(this.getCurrentFactAssertionString(false));
            JOptionPane.showMessageDialog(this, "Assertion done.\nPlease check the log for Messages.");
        } else if (event.getSource() == this.backButton) {
            if (this.step > 0) {
                --this.step;
                this.showCurrentStep();
            }
        } else if (event.getSource() == this.nextButton) {
            if (this.step < 1) {
                ++this.step;
                this.showCurrentStep();
            }
        } else if (event.getSource() == this.cancelButton) {
            this.close();
        } else if (event.getSource() == this.reloadButtondumpAreaFact) {
            this.dumpAreaFact.setText(this.getCurrentFactAssertionString(true));
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.moduleList.getSelectionModel()) {
            this.initTemplateList();
        } else if (event.getSource() == this.templateList.getSelectionModel()) {
            if (this.templateList.getSelectedIndex() > -1) {
                Slot[] slots;
                this.nextButton.setEnabled(true);
                Module module = this.engine.getWorkingMemory().findModule(String.valueOf(this.moduleList.getSelectedValue()));
                Template tmp = module.getTemplate(String.valueOf(this.templateList.getSelectedValue()));
                this.dumpAreaTemplate.setText("(deftemplate " + tmp.getName() + "\n");
                Slot[] slotArray = slots = (Slot[])tmp.getAllSlots();
                int n = slots.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot slot = slotArray[n2];
                    this.dumpAreaTemplate.append("    (");
                    if (slot instanceof MultiSlot) {
                        this.dumpAreaTemplate.append("multislot");
                    } else {
                        this.dumpAreaTemplate.append("slot");
                    }
                    this.dumpAreaTemplate.append(" " + slot.getName() + ")\n");
                    ++n2;
                }
                this.dumpAreaTemplate.append(")");
            } else {
                this.nextButton.setEnabled(false);
            }
        }
    }

    private String getCurrentFactAssertionString(boolean print) {
        Module module = this.engine.getWorkingMemory().findModule(String.valueOf(this.moduleList.getSelectedValue()));
        Template tmp = module.getTemplate(String.valueOf(this.templateList.getSelectedValue()));
        StringBuilder res = new StringBuilder("(assert (" + tmp.getName());
        for (Slot slot : this.factComponents.keySet()) {
            JComponent currComponent = this.factComponents.get(slot);
            if (print) {
                res.append("\n\t");
            }
            res.append("(" + slot.getName() + " ");
            if (slot instanceof MultiSlot) {
                Object[] values = ((DefaultListModel)((JList)currComponent).getModel()).toArray();
                int i = 0;
                while (i < values.length) {
                    if (i > 0) {
                        res.append(" ");
                    }
                    res.append("\"" + values[i].toString() + "\"");
                    ++i;
                }
            } else if (slot.getValueType() != 13) {
                res.append("\"" + ((JTextField)currComponent).getText() + "\"");
            }
            res.append(")");
        }
        if (print) {
            res.append("\n");
        }
        res.append("))");
        return res.toString();
    }

    private final class MultiSlotEditor
    implements ActionListener,
    PopupMenuListener {
        private JList list;
        private DefaultListModel listModel = new DefaultListModel();
        private JPopupMenu popupMenu = new JPopupMenu();
        private JMenuItem addMenuItem = new JMenuItem("add value", IconLoader.getImageIcon("add"));
        private JMenuItem editMenuItem;
        private JMenuItem deleteMenuItem;

        private MultiSlotEditor() {
            this.addMenuItem.addActionListener(this);
            this.editMenuItem = new JMenuItem("edit value", IconLoader.getImageIcon("pencil"));
            this.editMenuItem.addActionListener(this);
            this.deleteMenuItem = new JMenuItem("remove value", IconLoader.getImageIcon("delete"));
            this.deleteMenuItem.addActionListener(this);
            this.popupMenu.add(this.addMenuItem);
            this.popupMenu.add(this.editMenuItem);
            this.popupMenu.add(this.deleteMenuItem);
            this.popupMenu.addPopupMenuListener(this);
            this.list = new JList(this.listModel);
            this.list.setVisibleRowCount(4);
            this.list.setComponentPopupMenu(this.popupMenu);
        }

        private JList getList() {
            return this.list;
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.addMenuItem) {
                String value = JOptionPane.showInputDialog("Enter the value:");
                this.listModel.addElement(value);
            } else if (event.getSource() == this.editMenuItem) {
                String value = JOptionPane.showInputDialog("Enter the value:", this.list.getSelectedValue());
                this.listModel.set(this.list.getSelectedIndex(), value);
            } else if (event.getSource() == this.deleteMenuItem) {
                int[] indices = this.list.getSelectedIndices();
                int i = indices.length - 1;
                while (i >= 0) {
                    this.listModel.remove(indices[i]);
                    --i;
                }
            }
        }

        public void popupMenuCanceled(PopupMenuEvent arg0) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
            this.addMenuItem.setVisible(true);
            if (this.list.getSelectedIndices().length > 1) {
                this.editMenuItem.setVisible(false);
                this.deleteMenuItem.setVisible(true);
            } else if (this.list.getSelectedIndices().length == 1) {
                this.editMenuItem.setVisible(true);
                this.deleteMenuItem.setVisible(true);
            } else {
                this.editMenuItem.setVisible(false);
                this.deleteMenuItem.setVisible(false);
            }
        }
    }
}

