/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jamocha.gui.JamochaGui;
import org.jamocha.gui.icons.IconLoader;

public class JamochaMenuBar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 2908247560107956066L;
    private JamochaGui gui;
    private JMenu fileMenu;
    private JMenuItem fileMenuBatch;
    private JMenuItem fileMenuCloseGui;
    private JMenuItem fileMenuQuit;

    public JamochaMenuBar(JamochaGui gui) {
        this.gui = gui;
        this.fileMenu = new JMenu("File");
        this.fileMenuBatch = new JMenuItem("Batch File ...", IconLoader.getImageIcon("lorry"));
        this.fileMenuBatch.addActionListener(this);
        this.fileMenuCloseGui = new JMenuItem("Close Gui", IconLoader.getImageIcon("disconnect"));
        this.fileMenuCloseGui.addActionListener(this);
        this.fileMenuQuit = new JMenuItem("Quit", IconLoader.getImageIcon("door_in"));
        this.fileMenuQuit.addActionListener(this);
        this.fileMenu.add(this.fileMenuBatch);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileMenuCloseGui);
        this.fileMenu.add(this.fileMenuQuit);
        this.add(this.fileMenu);
    }

    public void showCloseGui(boolean show) {
        this.fileMenuCloseGui.setVisible(show);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.fileMenuQuit) {
            this.gui.setExitOnClose(true);
            this.gui.close();
        } else if (event.getSource() == this.fileMenuCloseGui) {
            this.gui.setExitOnClose(false);
            this.gui.close();
        } else if (event.getSource() == this.fileMenuBatch) {
            File file;
            JFileChooser chooser = new JFileChooser(this.gui.getPreferences().get("menubar.batchLastPath", ""));
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null && file.isFile()) {
                this.gui.getPreferences().put("menubar.batchLastPath", file.getAbsolutePath());
                this.gui.getStringChannel().executeCommand("(batch " + file.getAbsolutePath() + ")");
                JOptionPane.showMessageDialog(this, "Batch process started.\nPlease check the log for Messages.\nThe process might be running in the background for a while.");
            }
        }
    }
}

