/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jamocha.gui.JamochaMenuBar;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.gui.tab.AbstractJamochaPanel;
import org.jamocha.gui.tab.FactsPanel;
import org.jamocha.gui.tab.FunctionsPanel;
import org.jamocha.gui.tab.LogPanel;
import org.jamocha.gui.tab.RetePanel;
import org.jamocha.gui.tab.SettingsPanel;
import org.jamocha.gui.tab.ShellPanel;
import org.jamocha.gui.tab.TemplatesPanel;
import org.jamocha.messagerouter.InterestType;
import org.jamocha.messagerouter.StringChannel;
import org.jamocha.rete.Rete;

public class JamochaGui
extends JFrame
implements ChangeListener {
    static final long serialVersionUID = 1L;
    static final Preferences preferences = Preferences.userRoot().node("org.jamocha.gui");
    private Rete engine;
    private JamochaMenuBar menuBar;
    private JTabbedPane tabbedPane;
    private List<AbstractJamochaPanel> panels = new LinkedList<AbstractJamochaPanel>();
    private boolean exitOnClose = false;
    private StringChannel stringChannel;

    public JamochaGui(Rete engine) {
        this.setLayout(new BorderLayout());
        this.setTitle("Jamocha");
        this.setSizeAndLocation();
        JPanel logoPanel = new JPanel(new BorderLayout());
        logoPanel.add((Component)new JLabel(IconLoader.getImageIcon("jamocha")), "East");
        this.add((Component)logoPanel, "North");
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.menuBar = new JamochaMenuBar(this);
        this.setJMenuBar(this.menuBar);
        this.engine = engine;
        ShellPanel shellPanel = new ShellPanel(this);
        this.tabbedPane.addTab("Shell", IconLoader.getImageIcon("application_osx_terminal"), shellPanel, "Jamocha Shell");
        this.panels.add(shellPanel);
        FactsPanel factsPanel = new FactsPanel(this);
        this.tabbedPane.addTab("Facts", IconLoader.getImageIcon("database"), factsPanel, "View or modify Facts");
        this.panels.add(factsPanel);
        TemplatesPanel templatesPanel = new TemplatesPanel(this);
        this.tabbedPane.addTab("Templates", IconLoader.getImageIcon("brick"), templatesPanel, "View or modify Templates");
        this.panels.add(templatesPanel);
        FunctionsPanel functionsPanel = new FunctionsPanel(this);
        this.tabbedPane.addTab("Functions", IconLoader.getImageIcon("cog"), functionsPanel, "View Functions");
        this.panels.add(functionsPanel);
        RetePanel retePanel = new RetePanel(this);
        this.tabbedPane.addTab("Rete", IconLoader.getImageIcon("eye"), retePanel, "View the Rete-network");
        this.panels.add(retePanel);
        LogPanel logPanel = new LogPanel(this);
        this.tabbedPane.addTab("Log", IconLoader.getImageIcon("monitor"), logPanel, "View alle messages from or to the Rete-engine");
        this.panels.add(logPanel);
        SettingsPanel settingsPanel = new SettingsPanel(this);
        this.tabbedPane.addTab("Settings", IconLoader.getImageIcon("wrench"), settingsPanel, "Settings for Jamocha");
        this.panels.add(settingsPanel);
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JamochaGui.this.close();
            }
        });
    }

    private void setSizeAndLocation() {
        int width = preferences.getInt("gui.width", 0);
        int height = preferences.getInt("gui.height", 0);
        int locx = preferences.getInt("gui.locx", -1);
        int locy = preferences.getInt("gui.locy", -1);
        if (locx == -1 || locy == -1) {
            this.setLocationByPlatform(true);
        } else {
            this.setLocation(locx, locy);
        }
        if (width <= 0 || height <= 0) {
            this.setSize(750, 550);
        } else {
            this.setSize(width, height);
        }
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
        this.menuBar.showCloseGui(!exitOnClose);
    }

    public Rete getEngine() {
        return this.engine;
    }

    public StringChannel getStringChannel() {
        if (this.stringChannel == null) {
            this.stringChannel = this.getEngine().getMessageRouter().openChannel("gui_string_channel", InterestType.NONE);
        }
        return this.stringChannel;
    }

    public void showGui() {
        this.setMinimumSize(new Dimension(600, 400));
        this.setVisible(true);
        this.panels.get(0).setFocus();
    }

    public Preferences getPreferences() {
        return preferences;
    }

    public void settingsChanged() {
        for (AbstractJamochaPanel panel : this.panels) {
            panel.settingsChanged();
        }
    }

    public void close() {
        if (this.stringChannel != null) {
            this.getEngine().getMessageRouter().closeChannel(this.stringChannel);
        }
        preferences.putInt("gui.width", this.getWidth());
        preferences.putInt("gui.height", this.getHeight());
        preferences.putInt("gui.locx", this.getX());
        preferences.putInt("gui.locy", this.getY());
        for (AbstractJamochaPanel panel : this.panels) {
            panel.close();
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        this.setVisible(false);
        this.dispose();
        if (this.exitOnClose) {
            this.engine.close();
            System.exit(0);
        }
    }

    public void stateChanged(ChangeEvent event) {
        ((AbstractJamochaPanel)this.tabbedPane.getSelectedComponent()).setFocus();
    }
}

