/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jamocha.gui.icons.IconLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchResultBrowser
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel topPanel;
    private JButton batchResultsButton;
    private JButton removeButton;
    private JButton reloadButton;
    private JButton closeButton;
    private JTextArea aboutArea;
    private JComboBox resultsBox;
    private ResultBoxModel resultsBoxModel;
    private Map<String, String> batchResults;

    BatchResultBrowser(JButton batchResultsButton) {
        this.batchResultsButton = batchResultsButton;
        this.topPanel = new JPanel();
        this.setLocationByPlatform(true);
        this.setSize(500, 400);
        this.setLayout(new BorderLayout());
        this.resultsBoxModel = new ResultBoxModel();
        this.resultsBox = new JComboBox(this.resultsBoxModel);
        this.removeButton = new JButton(IconLoader.getImageIcon("delete"));
        this.removeButton.addActionListener(this);
        this.removeButton.setToolTipText("Remove this batch result");
        this.reloadButton = new JButton(IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButton.addActionListener(this);
        this.reloadButton.setToolTipText("Reload the list of available batch results");
        this.topPanel.add(this.resultsBox);
        this.topPanel.add(this.removeButton);
        this.topPanel.add(this.reloadButton);
        this.add((Component)this.topPanel, "North");
        this.aboutArea = new JTextArea();
        this.aboutArea.setBorder(BorderFactory.createEmptyBorder());
        this.aboutArea.setLineWrap(true);
        this.aboutArea.setWrapStyleWord(true);
        this.aboutArea.setEditable(false);
        this.add((Component)new JScrollPane(this.aboutArea, 22, 31), "Center");
        this.resultsBox.addActionListener(this);
        JPanel closePanel = new JPanel(new FlowLayout(2));
        this.closeButton = new JButton("close");
        this.closeButton.addActionListener(this);
        closePanel.add(this.closeButton);
        this.add((Component)closePanel, "South");
        batchResultsButton.setIcon(IconLoader.getImageIcon("lorry"));
    }

    void setResults(Map<String, String> batchResults) {
        this.batchResults = batchResults;
        this.resultsBoxModel.setItems(batchResults.keySet().toArray());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.closeButton)) {
            this.dispose();
        } else if (event.getSource().equals(this.resultsBox)) {
            Object item = this.resultsBox.getSelectedItem();
            if (item != null) {
                this.aboutArea.setText(this.batchResults.get(item.toString()));
            }
            this.batchResultsButton.setIcon(IconLoader.getImageIcon("lorry"));
        } else if (event.getSource().equals(this.removeButton)) {
            Object item = this.resultsBox.getSelectedItem();
            if (item != null) {
                this.resultsBoxModel.removeItem(item);
                this.batchResults.remove(item);
                this.aboutArea.setText("");
                this.resultsBox.setSelectedIndex(-1);
                if (this.batchResults.isEmpty()) {
                    this.batchResultsButton.setVisible(false);
                }
            }
        } else if (event.getSource().equals(this.reloadButton)) {
            this.resultsBoxModel.setItems(this.batchResults.keySet().toArray());
            this.aboutArea.setText("");
            this.resultsBox.setSelectedIndex(-1);
        }
    }

    private class ResultBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;
        private Object[] items;

        private ResultBoxModel() {
        }

        private void setItems(Object[] items) {
            this.items = items;
            if (items != null) {
                this.fireContentsChanged(this, 0, items.length);
            } else {
                this.fireContentsChanged(this, 0, 0);
            }
        }

        private void removeItem(Object item) {
            if (this.items != null) {
                LinkedList<Object> temp = new LinkedList<Object>();
                Object[] objectArray = this.items;
                int n = this.items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object tmpItem = objectArray[n2];
                    if (!tmpItem.equals(item)) {
                        temp.add(tmpItem);
                    }
                    ++n2;
                }
                this.items = temp.toArray();
                this.fireContentsChanged(this, 0, this.items.length);
            }
        }

        public Object getElementAt(int index) {
            if (this.items != null && index > -1 && index < this.items.length) {
                return this.items[index];
            }
            return null;
        }

        public int getSize() {
            if (this.items == null) {
                return 0;
            }
            return this.items.length;
        }
    }
}

