/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.cube;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;

public class HTTPLogGenerator {
    public static final String[] ips = new String[]{"192.168.0.10", "192.168.0.11", "192.68.0.12", "192.168.0.13", "192.168.0.14", "192.168.0.15", "192.68.0.16", "192.168.0.17", "192.168.0.18", "192.168.0.19", "192.68.0.20", "192.168.0.21"};
    public static final String[] dbips = new String[]{"192.168.0.50", "192.168.0.51", "192.68.0.52", "192.168.0.53"};
    public static final String[] urls = new String[]{"/GetContent", "/StoreContent", "/GetListing", "/SearchContent", "/GetContentHistory", "/QueueContent"};
    protected PrintWriter writer = null;
    protected Random random = new Random();
    public Date defaultDate = null;
    public SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    protected GregorianCalendar calendar = new GregorianCalendar();

    public HTTPLogGenerator() {
        try {
            this.defaultDate = this.dateFormat.parse("2010/03/01 08:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void generateData(String file, int count) {
        try {
            this.writer = new PrintWriter(file);
            int i = 0;
            while (i < count) {
                String ip = ips[this.random.nextInt(ips.length - 1)];
                String dbip = dbips[this.random.nextInt(dbips.length - 1)];
                String url = urls[this.random.nextInt(urls.length - 1)];
                int bytes = 2000 + this.random.nextInt(4000);
                int et = 1000 + this.random.nextInt(40000);
                int trandom = this.random.nextInt(900000);
                this.calendar.setTime(this.defaultDate);
                this.calendar.add(13, trandom);
                long startlong = this.calendar.getTimeInMillis();
                String start = String.valueOf(startlong);
                long startlong2 = startlong + (long)this.random.nextInt(350);
                String start2 = String.valueOf(startlong2);
                this.calendar.add(14, et);
                long endlong = this.calendar.getTimeInMillis();
                String end = String.valueOf(endlong);
                long endlong2 = endlong - (long)this.random.nextInt(350);
                String end2 = String.valueOf(endlong2);
                int transactionId = this.random.nextInt(count);
                this.printLog(ip, url, bytes, et, start, end, String.valueOf(transactionId));
                this.printDatabaseLog(dbip, bytes - 200, (int)(endlong2 - startlong2), start2, end2, String.valueOf(transactionId));
                ++i;
            }
            this.writer.close();
            System.out.println("Completed generating data!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printLog(String ip, String url, int bytesSent, int elapsedTime, String start, String end, String transactionId) {
        this.writer.write("(HTTPLog (IPAddress \"" + ip + "\")(URL \"" + url + "\")(action \"\")(bytesSent " + bytesSent + ")(elapsedTime " + elapsedTime + ")(hostname \"\")(logType \"\")");
        this.writer.write("(portNumber 8080)(protocol \"HTTP/1.1\")(requestBody \"\")(requestHeaders \"\")(requestParameters \"\")(serverType \"Tomcat 6\")");
        this.writer.write("(sessionID \"\")(statusCode \"200\")(statusMessage \"\")(threadID \"\")(timestamp " + start + ")(endTime " + end + ")(transactionID \"" + transactionId + "\"))\n");
    }

    public void printDatabaseLog(String ip, int bytesSent, int elapsedTime, String start, String end, String transactionId) {
        this.writer.write("(DatabaseQueryLog (IPAddress \"" + ip + "\")(bytesSent " + bytesSent + ")(elapsedTime " + elapsedTime + ")(databaseName \"Prod01\")(databaseType \"oracle 10g\")");
        this.writer.write("(portNumber 1526)(queryString \"select * from Content where\")(queryType \"select\")");
        this.writer.write("(timestamp " + start + ")(endTime " + end + ")(transactionID \"" + transactionId + "\"))\n");
    }

    public static void main(String[] args) {
        if (args != null && args.length >= 2) {
            String file = args[0];
            int count = Integer.parseInt(args[1]);
            HTTPLogGenerator gen = new HTTPLogGenerator();
            gen.generateData(file, count);
        }
    }
}

