/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.cube;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;

public class DatabaseLogGenerator {
    public static final String[] ips = new String[]{"192.168.0.50", "192.168.0.51", "192.68.0.52", "192.168.0.53"};
    protected PrintWriter writer = null;
    protected Random random = new Random();
    public Date defaultDate = null;
    public SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    protected GregorianCalendar calendar = new GregorianCalendar();

    public DatabaseLogGenerator() {
        try {
            this.defaultDate = this.dateFormat.parse("2010/03/01 08:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void generateData(String file, int count) {
        try {
            this.writer = new PrintWriter(file);
            int i = 0;
            while (i < count) {
                String ip = ips[this.random.nextInt(ips.length - 1)];
                int bytes = 2000 + this.random.nextInt(4000);
                int et = 5000 + this.random.nextInt(10000);
                int trandom = this.random.nextInt(800000);
                this.calendar.setTime(this.defaultDate);
                this.calendar.add(13, trandom);
                String start = this.calendar.getTime().toString();
                this.calendar.add(14, et);
                String end = this.calendar.getTime().toString();
                int transactionId = this.random.nextInt(10000);
                this.printLog(ip, bytes, et, start, end, String.valueOf(transactionId));
                ++i;
            }
            this.writer.close();
            System.out.println("Completed generating data!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printLog(String ip, int bytesSent, int elapsedTime, String start, String end, String transactionId) {
        this.writer.write("(DatabaseQueryLog (IPAddress \"" + ip + "\")(bytesSent " + bytesSent + ")(elapsedTime " + elapsedTime + ")(databaseName \"Prod01\")(databaseType \"oracle 10g\")");
        this.writer.write("(portNumber 1526)(queryString \"select * from Content where\")(queryType \"select\")");
        this.writer.write("(statusCode \"200\")(timestamp \"" + start + "\")(endTime \"" + end + "\")(transactionID \"" + transactionId + "\"))\n");
    }

    public static void main(String[] args) {
        if (args != null && args.length >= 2) {
            String file = args[0];
            int count = Integer.parseInt(args[1]);
            DatabaseLogGenerator gen = new DatabaseLogGenerator();
            gen.generateData(file, count);
        }
    }
}

