/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha;

import org.jamocha.gui.JamochaGui;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Shell;

public class Morendo {
    private JamochaGui jamochaGui;
    private Shell shell;
    private Rete engine;

    public static void main(String[] args) {
        boolean guiStarted = false;
        boolean shellStarted = false;
        Morendo jamocha = new Morendo(new Rete());
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-gui")) {
                    jamocha.startGui();
                    guiStarted = true;
                } else if (args[i].equalsIgnoreCase("-shell")) {
                    jamocha.startShell();
                    shellStarted = true;
                }
                ++i;
            }
        }
        if (!shellStarted && !guiStarted) {
            jamocha.showUsage();
        } else if (!shellStarted) {
            jamocha.getJamochaGui().setExitOnClose(true);
        }
    }

    Morendo(Rete engine) {
        this.engine = engine;
    }

    public void startShell() {
        if (this.shell == null) {
            Thread shellThread = new Thread(){

                public void run() {
                    Morendo.this.shell = new Shell(Morendo.this.engine);
                    Morendo.this.shell.run();
                }
            };
            shellThread.start();
        }
    }

    public void startGui() {
        if (this.jamochaGui == null) {
            this.jamochaGui = new JamochaGui(this.engine);
            Thread guiThread = new Thread(){

                public void run() {
                    Morendo.this.jamochaGui.showGui();
                }
            };
            guiThread.start();
        }
    }

    public void showUsage() {
        String sep = System.getProperty("line.separator");
        System.out.println("You have to pass one or more of the following arguments:" + sep + sep + "-gui:   starts a graphical user interface." + sep + "-shell: starts a simple Shell.");
        System.exit(0);
    }

    public JamochaGui getJamochaGui() {
        return this.jamochaGui;
    }

    public Shell getShell() {
        return this.shell;
    }
}

