/*
 * Copyright 2002-2008 The Jamocha Team
 * 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.jamocha.org/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package org.jamocha.communication.events;

import org.jamocha.engine.modules.Module;

public class ModulesChangedEvent extends AbstractEvent {

	protected Module module;

	protected ModulesChangedEventType type;

	public enum ModulesChangedEventType {
		MODULE_ADDED, MODULE_REMOVED
	}

	public ModulesChangedEvent(Object source, Module m,
			ModulesChangedEventType type) {
		super(source);
		module = m;
		this.type = type;
	}

	public Module getModule() {
		return module;
	}

	public ModulesChangedEventType getType() {
		return type;
	}

}
