/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rules;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.formatter.Formatter;
import org.jamocha.rules.AbstractCondition;
import org.jamocha.rules.Condition;
import org.jamocha.rules.ConditionVisitor;
import org.jamocha.rules.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCondition
extends AbstractCondition {
    private static final long serialVersionUID = 1L;
    protected String templateName = null;
    protected List<Constraint> constraints = new ArrayList<Constraint>();
    protected Template template = null;

    @Override
    public <T, S> S acceptVisitor(ConditionVisitor<T, S> visitor, T data) {
        return visitor.visit(this, data);
    }

    public ObjectCondition(List<Constraint> constraints, String templateName) {
        this.constraints = constraints;
        for (Constraint cs : constraints) {
            cs.setParentCondition(this);
        }
        this.templateName = templateName;
        this.registerAsParentCondition();
    }

    public ObjectCondition(ObjectCondition c) {
        super(c);
        this.constraints = new ArrayList<Constraint>();
        this.templateName = c.templateName;
        this.registerAsParentCondition();
    }

    private void registerAsParentCondition() {
        for (Constraint c : this.constraints) {
            c.setParentCondition(this);
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public ObjectCondition clone() {
        ArrayList<Constraint> newConstr = new ArrayList<Constraint>();
        for (Constraint c : this.constraints) {
            newConstr.add(c.clone());
        }
        ObjectCondition result = new ObjectCondition(newConstr, this.templateName);
        return result;
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public boolean replaceConstraint(Constraint old, Constraint n) {
        int i = this.constraints.indexOf(old);
        if (i == -1) {
            return false;
        }
        this.constraints.remove(i);
        this.constraints.add(n);
        n.setParentCondition(this);
        return true;
    }

    public void addConstraint(Constraint c) {
        this.constraints.add(c);
        c.setParentCondition(this);
    }

    @Override
    public List<Constraint> getFlatConstraints() {
        return this.getConstraints();
    }

    @Override
    public boolean testEquals(Condition o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ObjectCondition)) {
            return false;
        }
        ObjectCondition objectcon = (ObjectCondition)o;
        return objectcon.templateName.equals(this.templateName);
    }

    @Override
    public String dump(String prefix) {
        return prefix + "(object " + this.templateName + ")";
    }
}

