/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rules;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Binding;
import org.jamocha.engine.BoundParam;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ExecuteException;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.AssertConfiguration;
import org.jamocha.engine.configurations.ModifyConfiguration;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.configurations.SlotConfiguration;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.functions.FunctionNotFoundException;
import org.jamocha.engine.nodes.FactTuple;
import org.jamocha.engine.nodes.TerminalNode;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;
import org.jamocha.rules.Action;
import org.jamocha.rules.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionAction
implements Action {
    private static final long serialVersionUID = 1L;
    protected Function function = null;
    protected List<Parameter> parameters;
    protected Engine engine;
    protected Rule parent;

    public FunctionAction(String functionName, Engine engine, Rule parentRule, List<Parameter> params) throws FunctionNotFoundException {
        this.engine = engine;
        this.parent = parentRule;
        this.parameters = params;
        engine.getFunctionMemory().findFunction(functionName);
    }

    public FunctionAction(Function function, Engine engine, Rule parentRule, List<Parameter> params) {
        this.function = function;
        this.engine = engine;
        this.parent = parentRule;
        this.parameters = params;
    }

    protected void substituteBoundParams(Parameter[] params, TerminalNode tnode, FactTuple tuple) {
        for (int idx = 0; idx < params.length; ++idx) {
            Parameter param = params[idx];
            if (param instanceof BoundParam) {
                BoundParam bp = (BoundParam)param;
                Binding binding = this.engine.getRuleCompiler().getBinding(bp.getVariableName(), tnode, this.parent);
                if (binding == null) {
                    params[idx] = bp;
                    continue;
                }
                try {
                    JamochaValue newObj = binding.isWholeFactBinding() ? JamochaValue.newFactId(tuple.getFact((Integer)binding.getTupleIndex().get()).getFactId()) : tuple.getFact((Integer)binding.getTupleIndex().get()).getSlotValue(binding.getSlotIndex());
                    params[idx] = newObj;
                }
                catch (EvaluationException e) {
                    Logging.logger(this.getClass()).fatal(e);
                }
                continue;
            }
            if (param instanceof ModifyConfiguration) {
                ModifyConfiguration mc = (ModifyConfiguration)param;
                mc = (ModifyConfiguration)mc.clone();
                params[idx] = mc;
                BoundParam factBp = (BoundParam)mc.getFactBinding();
                Binding binding = this.engine.getRuleCompiler().getBinding(factBp.getVariableName(), tnode, this.parent);
                JamochaValue newObj = null;
                if (binding.isWholeFactBinding()) {
                    newObj = JamochaValue.newFactId(tuple.getFact((Integer)binding.getTupleIndex().get()).getFactId());
                } else {
                    try {
                        newObj = tuple.getFact((Integer)binding.getTupleIndex().get()).getSlotValue(binding.getSlotIndex());
                    }
                    catch (EvaluationException e) {
                        Logging.logger(this.getClass()).fatal(e);
                    }
                }
                mc.setFactBinding(newObj);
                for (Parameter parameter : mc.getSlots()) {
                    Parameter[] p = ((SlotConfiguration)parameter).getSlotValues();
                    this.substituteBoundParams(p, tnode, tuple);
                }
                continue;
            }
            if (param instanceof AssertConfiguration) {
                AssertConfiguration ac = (AssertConfiguration)((AssertConfiguration)param).clone();
                params[idx] = ac;
                this.substituteBoundParams(ac.getData(), tnode, tuple);
                continue;
            }
            if (param instanceof JamochaValue) continue;
            if (param instanceof Signature) {
                JamochaValue iRes = null;
                boolean subst = true;
                try {
                    Signature iSig = (Signature)((Signature)param).clone();
                    params[idx] = iSig;
                    this.substituteBoundParams(iSig.getParameters(), tnode, tuple);
                    ArrayList<Parameter> iParams = new ArrayList<Parameter>();
                    for (Parameter parameter : iSig.getParameters()) {
                        iParams.add(parameter);
                    }
                    Function iFunc = iSig.lookUpFunction(this.engine);
                    FunctionAction iFuncAction = new FunctionAction(iFunc, this.engine, this.parent, iParams);
                    iRes = iFuncAction.executeAction(tuple, tnode);
                }
                catch (FunctionNotFoundException e) {
                    subst = false;
                }
                catch (ExecuteException e) {
                    subst = false;
                }
                if (!subst) continue;
                params[idx] = iRes;
                continue;
            }
            Logging.logger(this.getClass()).fatal("cannot handle parameter " + param);
        }
    }

    @Override
    public JamochaValue executeAction(FactTuple facts, TerminalNode tnode) throws ExecuteException {
        try {
            Parameter[] params = new Parameter[this.parameters.size()];
            params = this.parameters.toArray(params);
            this.substituteBoundParams(params, tnode, facts);
            return this.function.executeFunction(this.engine, params);
        }
        catch (Exception e) {
            throw new ExecuteException("Error executing function '" + this.function.getName() + "'", e);
        }
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    public Function getFunction() {
        return this.function;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }
}

