/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rules;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ExpressionSequence;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.TemporalValidity;
import org.jamocha.engine.configurations.DeclarationConfiguration;
import org.jamocha.engine.configurations.DefruleConfiguration;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.configurations.TemporalValidityConfiguration;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.functions.FunctionNotFoundException;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.scope.Scope;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;
import org.jamocha.rules.Action;
import org.jamocha.rules.Condition;
import org.jamocha.rules.FunctionAction;
import org.jamocha.rules.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Defrule
implements Rule {
    private static final long serialVersionUID = 1L;
    protected String name = null;
    protected List<Condition> conditions = null;
    protected List<Action> actions = null;
    protected int salience = 100;
    protected boolean autoFocus = false;
    protected Module module = null;
    protected Scope outerScope = null;
    private String description = "";
    private boolean active = true;
    private boolean slowCompile = false;
    protected boolean watch = false;
    protected long effectiveDate = 0L;
    protected long expirationDate = 0L;
    protected TemporalValidity temporalValidity;

    @Override
    public TemporalValidity getTemporalValidity() {
        return this.temporalValidity;
    }

    @Override
    public void setTemporalValidity(TemporalValidity temporalValidity) {
        this.temporalValidity = temporalValidity;
    }

    protected Defrule() {
    }

    public Defrule(Module module, String name, List<Condition> lhs, List<Action> rhs) {
        this();
        this.conditions = lhs;
        this.actions = rhs;
        this.name = name;
        this.module = module;
    }

    public Defrule(Module module, DefruleConfiguration configuration, Engine engine) throws EvaluationException {
        this();
        Condition[] arrConds;
        this.module = module;
        this.name = configuration.getRuleName();
        this.description = configuration.getRuleDescription();
        this.setDeclaration(configuration.getDeclarationConfiguration(), engine);
        this.conditions = new ArrayList<Condition>();
        for (Condition c : arrConds = configuration.getConditions()) {
            this.conditions.add(c);
        }
        this.setActions(configuration.getActions(), engine);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean getWatch() {
        return this.watch;
    }

    protected void setDeclaration(DeclarationConfiguration declarationConfiguration, Engine engine) throws EvaluationException {
        if (declarationConfiguration != null) {
            Parameter param = null;
            param = declarationConfiguration.getAutoFocus();
            if (param != null) {
                this.setAutoFocus(param.getValue(engine).getBooleanValue());
            }
            if ((param = declarationConfiguration.getSlowCompile()) != null) {
                this.setSlowCompile(param.getValue(engine).getBooleanValue());
            }
            if ((param = declarationConfiguration.getSalience()) != null) {
                this.setSalience(param.getValue(engine).getLongValue());
            }
            if ((param = declarationConfiguration.getTemporalValidity()) != null) {
                TemporalValidityConfiguration tvc = (TemporalValidityConfiguration)param;
                this.setTemporalValidity(tvc.getTemporalValidity(engine));
            }
        }
    }

    @Override
    public boolean getAutoFocus() {
        return this.autoFocus;
    }

    @Override
    public void setAutoFocus(boolean auto) {
        this.autoFocus = auto;
    }

    @Override
    public int getSalience() {
        return this.salience;
    }

    @Override
    public void setSalience(int sal) {
        this.salience = sal;
    }

    public void setSalience(long sal) {
        this.salience = (int)sal;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public long getEffectiveDate() {
        return this.effectiveDate;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public void setEffectiveDate(long mstime) {
        this.effectiveDate = mstime;
    }

    public void setExpirationDate(long mstime) {
        this.expirationDate = mstime;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public Module parentModule() {
        return this.module;
    }

    protected static long getDateTime(String date) {
        if (date != null && date.length() > 0) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("mm/dd/yyyy HH:mm");
                return df.parse(date).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0L;
            }
        }
        return 0L;
    }

    public Scope popScope() {
        return this.outerScope;
    }

    public void pushScope(Scope scope) {
        this.outerScope = scope;
    }

    public Scope getOuterScope() {
        return this.outerScope;
    }

    @Override
    public int getComplexity() {
        int complexity = 0;
        for (Condition c : this.conditions) {
            complexity += c.getComplexity();
        }
        return complexity;
    }

    public Defrule clone(Engine engine) throws CloneNotSupportedException {
        DeclarationConfiguration newDecl = new DeclarationConfiguration();
        newDecl.setAutoFocus(JamochaValue.newBoolean(this.getAutoFocus()));
        newDecl.setSalience(JamochaValue.newLong(this.getSalience()));
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Condition c : this.getConditions()) {
            conditions.add(c);
        }
        Defrule newRule = new Defrule(this.module, this.getName(), conditions, this.actions);
        try {
            newRule.setDeclaration(newDecl, engine);
        }
        catch (EvaluationException e) {
            engine.writeMessage(e.getMessage());
        }
        newRule.setDescription(this.getDescription());
        return newRule;
    }

    @Override
    public Defrule clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.parentModule().getName() + "::" + this.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Rule other = (Rule)obj;
        if (!other.getName().equals(this.name)) {
            return false;
        }
        return other.parentModule().getName().equals(this.module.getName());
    }

    @Override
    public String getDump() {
        return this.toString();
    }

    @Override
    public void setDescription(String text) {
        this.description = text;
    }

    private void setActions(ExpressionSequence actions, Engine engine) {
        this.actions = new ArrayList<Action>();
        for (int i = 0; i < actions.size(); ++i) {
            Parameter acn = actions.get(i);
            if (!(acn instanceof Signature)) continue;
            Signature sig = (Signature)acn;
            Function function = null;
            try {
                function = sig.lookUpFunction(engine);
            }
            catch (FunctionNotFoundException e) {
                Logging.logger(this.getClass()).fatal(e);
            }
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            for (Parameter p : sig.getParameters()) {
                params.add(p);
            }
            FunctionAction faction = new FunctionAction(function, engine, (Rule)this, params);
            this.actions.add(faction);
        }
    }

    public boolean getSlowCompile() {
        return this.slowCompile;
    }

    public void setSlowCompile(boolean slowCompile) {
        this.slowCompile = slowCompile;
    }
}

