/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jamocha.rules.AbstractCondition;
import org.jamocha.rules.Condition;
import org.jamocha.rules.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConditionWithNested
extends AbstractCondition {
    protected List<Condition> nested = new ArrayList<Condition>();

    public ConditionWithNested() {
    }

    public ConditionWithNested(ConditionWithNested c) {
        super(c);
        for (Condition condition : c.nested) {
            this.addNestedCondition(condition.clone());
        }
    }

    public void addNestedCondition(Condition ce) {
        this.nested.add(ce);
        ce.setParentCondition(this);
    }

    public void replaceNestedCondition(Condition oldce, Condition ce) {
        int index = this.nested.indexOf(oldce);
        this.nested.add(index, ce);
        ce.setParentCondition(this);
        this.nested.remove(index + 1);
    }

    public List<Condition> getNestedConditions() {
        return this.nested;
    }

    @Override
    public List<Constraint> getConstraints() {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Condition c : this.nested) {
            result.addAll(c.getConstraints());
        }
        return result;
    }

    @Override
    public List<Constraint> getFlatConstraints() {
        return new ArrayList<Constraint>();
    }

    @Override
    public int getComplexity() {
        int comp = 0;
        for (Condition child : this.nested) {
            comp += child.getComplexity();
        }
        return comp;
    }

    @Override
    public Condition clone() {
        ConditionWithNested newCwn;
        try {
            newCwn = (ConditionWithNested)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        for (Condition c : this.nested) {
            newCwn.addNestedCondition(c.clone());
        }
        return newCwn;
    }

    public void removeNestedCondition(Condition c) {
        this.nested.remove(c);
    }

    @Override
    public boolean testEquals(Condition o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!(o instanceof ConditionWithNested)) {
            return false;
        }
        ConditionWithNested andcon = (ConditionWithNested)o;
        LinkedList<Condition> list1 = new LinkedList<Condition>(this.getNestedConditions());
        LinkedList<Condition> list2 = new LinkedList<Condition>(andcon.getNestedConditions());
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator i = list1.iterator();
        while (i.hasNext()) {
            Condition condition1 = (Condition)i.next();
            Iterator j = list2.iterator();
            while (j.hasNext()) {
                Condition condition2 = (Condition)j.next();
                if (!condition1.testEquals(condition2)) continue;
                i.remove();
                j.remove();
            }
        }
        return list1.isEmpty() && list2.isEmpty();
    }

    public String dump(String prefix, String name) {
        String out = "";
        out = out + prefix + "(" + name + "\n";
        for (Condition condition : this.nested) {
            out = out + condition.dump(prefix + "   ") + "\n";
        }
        out = out + prefix + ")";
        return out;
    }
}

