/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.parser;

import java.util.Calendar;
import java.util.Date;

public class ParserUtils {
    public static String getStringLiteral(String text) {
        if (text != null && text.length() > 1 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            StringBuffer buf = new StringBuffer();
            int len = text.length() - 1;
            boolean escaping = false;
            for (int i = 1; i < len; ++i) {
                char ch = text.charAt(i);
                if (escaping) {
                    buf.append(ch);
                    escaping = false;
                    continue;
                }
                if (ch == '\\') {
                    escaping = true;
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }
        return text;
    }

    public static String escapeStringLiteral(String text) {
        StringBuilder buffer = new StringBuilder();
        for (char chr : text.toCharArray()) {
            if (chr == '\"' || chr == '\\') {
                buffer.append('\\');
            }
            buffer.append(chr);
        }
        return buffer.toString();
    }

    public static String dateToString(Date date) {
        StringBuilder res = new StringBuilder();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        res.append(cal.get(1)).append("-");
        int month = cal.get(2) + 1;
        res.append(month < 10 ? "0" + month : Integer.valueOf(month)).append("-");
        int day = cal.get(5);
        res.append(day < 10 ? "0" + day : Integer.valueOf(day)).append(" ");
        int hour = cal.get(11);
        res.append(hour < 10 ? "0" + hour : Integer.valueOf(hour)).append(":");
        int minute = cal.get(12);
        res.append(minute < 10 ? "0" + minute : Integer.valueOf(minute)).append(":");
        int second = cal.get(13);
        res.append(second < 10 ? "0" + second : Integer.valueOf(second));
        res.append(cal.get(15));
        return res.toString();
    }

    public static long dateToLong(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getTimeInMillis();
    }
}

