/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.languages.sl.sl2clips_adapter.configurations;

import java.util.LinkedList;
import java.util.List;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.SLCompileType;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.SLConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WffSLConfiguration
implements SLConfiguration {
    boolean braces = true;
    private List<SLConfiguration> expressions = new LinkedList<SLConfiguration>();

    public boolean isBraces() {
        return this.braces;
    }

    public void setBraces(boolean braces) {
        this.braces = braces;
    }

    public void addExpression(SLConfiguration expression) {
        this.expressions.add(expression);
    }

    public List<SLConfiguration> getExpressions() {
        return this.expressions;
    }

    @Override
    public String compile(SLCompileType compileType) {
        StringBuilder res = new StringBuilder();
        if (!this.braces && this.expressions.size() == 1 && compileType == SLCompileType.RULE_LHS) {
            String possBoolean = this.expressions.get(0).compile(compileType);
            if (possBoolean.equalsIgnoreCase("true")) {
                return "(test (eq true true))";
            }
            if (possBoolean.equalsIgnoreCase("false")) {
                return "(test (eq true false))";
            }
        }
        if (this.braces) {
            res.append("(");
        }
        for (int i = 0; i < this.expressions.size(); ++i) {
            if (i > 0) {
                res.append(" ");
            }
            res.append(this.expressions.get(i).compile(compileType));
        }
        if (this.braces) {
            res.append(")");
        }
        return res.toString();
    }
}

