/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.languages.sl.sl2clips_adapter;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.languages.sl.sl2clips_adapter.CLIPS2SL;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class CLIPS2SLFunction
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new CLIPS2SLFunctionDescription();
    public static final String NAME = "clips2sl";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaType getReturnType() {
        return JamochaType.STRING;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.newString("");
        if (params == null || params.length != 1) {
            throw new IllegalParameterException(1);
        }
        JamochaValue value = params[0].getValue(engine);
        String slCode = CLIPS2SL.getSL(value, engine);
        result = JamochaValue.newString(slCode);
        return result;
    }

    private static final class CLIPS2SLFunctionDescription
    implements FunctionDescription {
        private CLIPS2SLFunctionDescription() {
        }

        public String getDescription() {
            return "translates CLIPS-Code resp. JamochaValues to SL which then will be returned as a String.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Jamochavalue that should be translated to SL.";
        }

        public String getParameterName(int parameter) {
            return "string";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.ANY;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.STRINGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

