/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.languages.sl.sl2clips_adapter;

import org.jamocha.engine.Engine;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class CLIPS2SL {
    private CLIPS2SL() {
    }

    public static String getSL(JamochaValue value, Engine engine) {
        Fact fact;
        StringBuilder res = new StringBuilder();
        if (value.getType().equals((Object)JamochaType.BOOLEAN) || value.getType().equals((Object)JamochaType.DATETIME) || value.getType().equals((Object)JamochaType.DOUBLE) || value.getType().equals((Object)JamochaType.LONG) || value.getType().equals((Object)JamochaType.IDENTIFIER)) {
            res.append(value.toString());
        } else if (value.getType().equals((Object)JamochaType.STRING)) {
            res.append("\"").append(value.toString()).append("\"");
        } else if (value.getType().equals((Object)JamochaType.LIST)) {
            res.append("(set \n");
            for (int i = 0; i < value.getListCount(); ++i) {
                res.append(" " + CLIPS2SL.getSL(value.getListValue(i), engine) + " ");
            }
            res.append(")");
        } else if (value.getType().equals((Object)JamochaType.FACT)) {
            Fact fact2 = value.getFactValue();
            Template tmpl = fact2.getTemplate();
            res.append("(" + tmpl.getName() + "\n");
            for (int i = 0; i < tmpl.getNumberOfSlots(); ++i) {
                try {
                    res.append("\t\t:" + tmpl.getSlot(i).getName() + " " + CLIPS2SL.getSL(fact2.getSlotValue(i), engine));
                    continue;
                }
                catch (EvaluationException e) {
                    e.printStackTrace();
                }
            }
            res.append(" )\n");
        } else if (value.getType().equals((Object)JamochaType.FACT_ID) && (fact = engine.getFactById(value.getFactIdValue())) != null) {
            Template tmpl = fact.getTemplate();
            res.append("(" + tmpl.getName() + "\n");
            for (int i = 0; i < tmpl.getNumberOfSlots(); ++i) {
                try {
                    res.append("\t\t:" + tmpl.getSlot(i).getName() + " " + CLIPS2SL.getSL(fact.getSlotValue(i), engine));
                    continue;
                }
                catch (EvaluationException e) {
                    e.printStackTrace();
                }
            }
            res.append(" )\n");
        }
        return res.toString();
    }
}

