/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.formatter;

import java.util.List;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.formatter.SFPFormatter;
import org.jamocha.parser.JamochaType;

public class HelpFormatter
extends SFPFormatter {
    public String visit(Function object) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(object.getName());
        List<String> aliases = object.getAliases();
        for (String alias : aliases) {
            sb.append(" | ").append(alias);
        }
        FunctionDescription desc = object.getDescription();
        this.increaseIndent();
        for (int i = 0; i < desc.getParameterCount(); ++i) {
            this.newLine(sb);
            if (desc.isParameterOptional(i)) {
                sb.append("[");
            } else {
                sb.append("(");
            }
            sb.append(desc.getParameterName(i));
            if (desc.isParameterOptional(i)) {
                sb.append("]");
            } else {
                sb.append(")");
            }
            sb.append(" <");
            JamochaType[] types = desc.getParameterTypes(i);
            for (int j = 0; j < types.length; ++j) {
                if (j > 0) {
                    sb.append(" | ");
                }
                sb.append((Object)types[j]);
            }
            sb.append(">");
            this.increaseIndent();
            this.newLine(sb);
            sb.append(desc.getParameterDescription(i));
            this.decreaseIndent();
        }
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(")");
        if (!desc.isParameterCountFixed()) {
            this.newLine(sb);
            sb.append("(The parameter count for this function is variable)");
        }
        this.newLine(sb);
        this.newLine(sb);
        sb.append("returns: <").append(this.formatParameterTypes(desc.getReturnType())).append(">");
        this.newLine(sb);
        this.newLine(sb);
        sb.append(desc.getDescription());
        String example = desc.getExample();
        if (example != null) {
            this.newLine(sb);
            this.newLine(sb);
            sb.append("Example(s):");
            this.newLine(sb);
            sb.append(example);
        }
        return sb.toString();
    }

    public String visit(Fact object) {
        StringBuilder sb = new StringBuilder();
        sb.append("f-").append(object.getFactId());
        sb.append(super.visit(object));
        return sb.toString();
    }

    private String formatParameterTypes(JamochaType[] types) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < types.length; ++j) {
            if (j > 0) {
                sb.append("|");
            }
            sb.append((Object)types[j]);
        }
        return sb.toString();
    }
}

