/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.workingmemory.elements;

import org.jamocha.engine.ConstraintViolationException;
import org.jamocha.engine.workingmemory.elements.AbstractSlot;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.IllegalConversionException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Slot
extends AbstractSlot {
    static final long serialVersionUID = -2401053364084360514L;
    protected JamochaValue value = JamochaValue.NIL;
    protected boolean silent = false;

    public Slot() {
    }

    public Slot(boolean silent) {
        this.silent = silent;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public Slot(String name) {
        this.setName(name);
    }

    public Slot(boolean silent, String name) {
        this(name);
        this.silent = silent;
    }

    public Slot(String name, JamochaValue value) {
        this(name);
        this.value = value;
    }

    public Slot(boolean silent, String name, JamochaValue value) {
        this(name, value);
        this.silent = silent;
    }

    public JamochaValue getValue() {
        return this.value;
    }

    public void setValue(JamochaValue val) throws ConstraintViolationException {
        if (this.inspectType(val)) {
            this.value = val;
        } else {
            try {
                this.value = val.implicitCast(this.getValueType());
            }
            catch (IllegalConversionException e) {
                throw new ConstraintViolationException("Could not cast value " + val + " to type " + (Object)((Object)this.getValueType()) + ".");
            }
        }
    }

    protected boolean inspectType(JamochaValue value) {
        return this.getValueType().equals((Object)JamochaType.UNDEFINED) || value.getType().equals((Object)JamochaType.BINDING) || this.getValueType().equals((Object)value.getType());
    }

    public Object clone() {
        Slot newslot = new Slot(this.silent);
        newslot.setId(this.getId());
        newslot.setName(this.getName());
        newslot.value = this.value;
        newslot.setValueType(this.getValueType());
        return newslot;
    }

    public String valueToString() {
        return this.value.toString();
    }

    public String toString() {
        String result = super.toString();
        result = result + this.valueToString();
        return result;
    }

    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    public boolean mergableTo(AbstractSlot other) {
        boolean result = super.mergableTo(other);
        if (result) {
            result = other instanceof Slot;
        }
        if (result) {
            result = this.getValue().equals(((Slot)other).getValue());
        }
        return result;
    }
}

