/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.workingmemory.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jamocha.Constants;
import org.jamocha.engine.AssertException;
import org.jamocha.engine.Engine;
import org.jamocha.engine.configurations.SlotConfiguration;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.workingmemory.elements.Deffact;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.MultiSlot;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.engine.workingmemory.elements.tags.Tag;
import org.jamocha.engine.workingmemory.elements.tags.TagIterator;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deftemplate
implements Template,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TemplateSlot[] slots;
    private boolean watch = false;
    private String templateName = null;
    private Template parent = null;
    private String description = null;
    protected List<Tag> tags;
    private String defclass = null;

    public Deftemplate(String name, String defclass, TemplateSlot[] slots) {
        this.templateName = name;
        this.defclass = defclass;
        this.slots = slots;
        this.tags = new ArrayList<Tag>();
    }

    public Deftemplate(String name, String defclass, TemplateSlot[] slots, Template parent) {
        this(name, defclass, slots);
        this.parent = parent;
    }

    public Deftemplate(String name) {
        this(name, null, null);
    }

    public Deftemplate(String name, Template parent) {
        this(name, null, null, parent);
    }

    public Deftemplate() {
        this(null, null, null, null);
    }

    @Override
    public Module checkUserDefinedModuleName(Engine engine) {
        if (this.templateName.indexOf("::") > 0) {
            String[] sp = this.templateName.split("::");
            this.templateName = sp[1];
            return engine.getModules().getModule(sp[0]);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.templateName;
    }

    @Override
    public int getNumberOfSlots() {
        return this.slots.length;
    }

    @Override
    public TemplateSlot[] getAllSlots() {
        return this.slots;
    }

    @Override
    public TemplateSlot getSlot(String name) {
        for (int idx = 0; idx < this.slots.length; ++idx) {
            if (!this.slots[idx].getName().equals(name)) continue;
            return this.slots[idx];
        }
        return null;
    }

    @Override
    public TemplateSlot getSlot(int id) {
        if (id == -1 || id >= this.slots.length) {
            return null;
        }
        return this.slots[id];
    }

    public Fact createFact(SlotConfiguration[] scs, Engine engine) throws EvaluationException {
        Boolean foundSlotMatching = false;
        SlotConfiguration sc = null;
        Slot slot = null;
        Slot[] slots = this.createFactSlots(engine);
        ArrayList<Slot> bslots = new ArrayList<Slot>();
        boolean hasbinding = false;
        for (int i = 0; i < scs.length; ++i) {
            foundSlotMatching = false;
            sc = scs[i];
            for (int j = 0; j < slots.length; ++j) {
                slot = slots[j];
                if (!slot.getName().equals(sc.getSlotName())) continue;
                foundSlotMatching = true;
                slot.setId(sc.getId());
                JamochaValue val = sc.getValue(engine);
                if (slot instanceof MultiSlot) {
                    if (!val.is(JamochaType.LIST)) {
                        JamochaValue[] values = new JamochaValue[]{val};
                        val = JamochaValue.newList(values);
                    }
                    for (int mdx = 0; mdx < val.getListCount(); ++mdx) {
                        JamochaValue v2 = val.getListValue(mdx);
                        if (v2.getType() != JamochaType.BINDING) continue;
                        Slot clone = (Slot)slot.clone();
                        clone.setValue(val);
                        bslots.add(clone);
                        hasbinding = true;
                        break;
                    }
                    slot.setValue(val);
                    break;
                }
                if (val == null) {
                    slot.setValue(JamochaValue.NIL);
                    break;
                }
                if (val.getType() == JamochaType.BINDING) {
                    slot.setValue(val);
                    Slot clone = (Slot)slot.clone();
                    clone.setValue(val);
                    bslots.add(clone);
                    hasbinding = true;
                    break;
                }
                slot.setValue(val);
                break;
            }
            if (foundSlotMatching.booleanValue()) continue;
            throw new AssertException("Could not find a slot for given slotname " + sc.getSlotName() + " in Template " + this.templateName + ".");
        }
        TemplateSlot ts = null;
        for (int i = 0; i < this.getAllSlots().length; ++i) {
            ts = this.getSlot(i);
            if (!ts.isRequired()) continue;
            String slotName = ts.getName();
            for (int j = 0; j < slots.length; ++j) {
                if (!slots[j].getName().equals(slotName) || !slots[j].getValue().equals(JamochaValue.NIL)) continue;
                throw new AssertException("A non-empty value is required for the slot " + ts.getName() + " by the corresponding template" + this.templateName + ".");
            }
        }
        Deffact newfact = new Deffact(this, slots);
        if (hasbinding) {
            Slot[] slts2 = new Slot[bslots.size()];
            newfact.boundSlots = bslots.toArray(slts2);
            newfact.hasBinding = true;
        }
        newfact.equalityIndex();
        return newfact;
    }

    private Slot[] createFactSlots(Engine engine) throws EvaluationException {
        Slot[] factSlots = new Slot[this.slots.length];
        for (int idx = 0; idx < factSlots.length; ++idx) {
            factSlots[idx] = this.slots[idx].createSlot(engine);
        }
        return factSlots;
    }

    @Override
    public boolean inUse() {
        for (int idx = 0; idx < this.slots.length; ++idx) {
            if (this.slots[idx].getNodeCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.format(ParserFactory.getFormatter());
    }

    @Override
    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.templateName + Constants.LINEBREAK);
        for (int idx = 0; idx < this.slots.length; ++idx) {
            buf.append("  (" + this.slots[idx].getName() + " (type " + (Object)((Object)this.slots[idx].getValueType()) + ") )" + Constants.LINEBREAK);
        }
        if (this.defclass != null) {
            buf.append("[" + this.defclass + "] ");
        }
        buf.append(")");
        return buf.toString();
    }

    public Deftemplate cloneDeftemplate() {
        Deftemplate dt = new Deftemplate(this.templateName, this.defclass, this.slots);
        return dt;
    }

    @Override
    public void evaluateStaticDefaults(Engine engine) throws EvaluationException {
        for (int i = 0; i < this.slots.length; ++i) {
            if (!this.slots[i].isStaticDefault()) continue;
            JamochaValue constantValue = this.slots[i].getDefaultExpression().getValue(engine);
            this.slots[i].setStaticDefaultExpression(constantValue);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDump(String modName) {
        StringBuffer buf = new StringBuffer();
        buf.append("(deftemplate " + modName + "::" + this.templateName + " ");
        for (int idx = 0; idx < this.slots.length; ++idx) {
            buf.append("(slot " + this.slots[idx].getName());
            if (this.slots[idx].getValueType() != JamochaType.UNDEFINED) {
                buf.append(" (type " + (Object)((Object)this.slots[idx].getValueType()) + ") ");
            }
            buf.append(") ");
        }
        if (this.defclass != null) {
            buf.append("[" + this.defclass + "] ");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    @Override
    public Iterator<Tag> getTags() {
        return this.getTags(Tag.class);
    }

    @Override
    public void addTag(Tag t) {
        this.tags.add(t);
    }

    @Override
    public Iterator<Tag> getTags(Class<? extends Tag> tagClass) {
        return new TagIterator(tagClass, this.tags);
    }

    @Override
    public String getDump() {
        return this.toString();
    }
}

