/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.rules.rulecompiler.beffy;

import java.util.ArrayList;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.rules.rulecompiler.beffy.BeffyRuleOptimizerDataPassOne;
import org.jamocha.rules.AndCondition;
import org.jamocha.rules.Condition;
import org.jamocha.rules.ConditionVisitor;
import org.jamocha.rules.ConditionWithNested;
import org.jamocha.rules.ExistsCondition;
import org.jamocha.rules.NotExistsCondition;
import org.jamocha.rules.ObjectCondition;
import org.jamocha.rules.OrCondition;
import org.jamocha.rules.TestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeffyRuleOptimizerPassOne
implements ConditionVisitor<BeffyRuleOptimizerDataPassOne, Condition> {
    public Condition optimize(Condition con) {
        Condition con2 = con.acceptVisitor(this, new BeffyRuleOptimizerDataPassOne());
        return con2;
    }

    private void insertNots(int count, Condition c) {
        if (count == 0) {
            return;
        }
        if (count > 1) {
            count %= 2;
        }
        if (c instanceof TestCondition) {
            if (count == 0) {
                return;
            }
            TestCondition tc = (TestCondition)c;
            Signature sig = new Signature("not");
            Parameter[] p = new Parameter[]{tc.getFunction()};
            sig.setParameters(p);
            tc.getParentCondition().replaceNestedCondition(tc, new TestCondition(sig));
            return;
        }
        ConditionWithNested parent = c.getParentCondition();
        ConditionWithNested n = count == 0 ? new ExistsCondition() : new NotExistsCondition();
        n.addNestedCondition(c);
        parent.replaceNestedCondition(c, n);
    }

    @Override
    public Condition visit(AndCondition c, BeffyRuleOptimizerDataPassOne data) {
        ConditionWithNested con = c;
        if (data.nestedNots % 2 == 1) {
            ConditionWithNested parent = c.getParentCondition();
            con = new OrCondition();
            for (Condition ce : c.getNestedConditions()) {
                con.addNestedCondition(ce);
            }
            parent.replaceNestedCondition(c, con);
        }
        for (Condition ce : new ArrayList<Condition>(con.getNestedConditions())) {
            ce.acceptVisitor(this, data);
        }
        return c;
    }

    @Override
    public Condition visit(ExistsCondition c, BeffyRuleOptimizerDataPassOne data) {
        ConditionWithNested parent = c.getParentCondition();
        AndCondition andcon = new AndCondition();
        for (Condition ce : c.getNestedConditions()) {
            andcon.addNestedCondition(ce);
        }
        parent.replaceNestedCondition(c, andcon);
        data.nestedNots += 2;
        andcon.acceptVisitor(this, data);
        data.nestedNots -= 2;
        return c;
    }

    @Override
    public Condition visit(NotExistsCondition c, BeffyRuleOptimizerDataPassOne data) {
        ConditionWithNested parent = c.getParentCondition();
        AndCondition andcon = new AndCondition();
        for (Condition ce : c.getNestedConditions()) {
            andcon.addNestedCondition(ce);
        }
        parent.replaceNestedCondition(c, andcon);
        ++data.nestedNots;
        andcon.acceptVisitor(this, data);
        --data.nestedNots;
        return c;
    }

    @Override
    public Condition visit(ObjectCondition c, BeffyRuleOptimizerDataPassOne data) {
        this.insertNots(data.nestedNots, c);
        return c;
    }

    @Override
    public Condition visit(OrCondition c, BeffyRuleOptimizerDataPassOne data) {
        ConditionWithNested con = c;
        if (data.nestedNots % 2 == 1) {
            ConditionWithNested parent = c.getParentCondition();
            con = new AndCondition();
            for (Condition ce : c.getNestedConditions()) {
                con.addNestedCondition(ce);
            }
            parent.replaceNestedCondition(c, con);
        }
        for (Condition ce : new ArrayList<Condition>(con.getNestedConditions())) {
            ce.acceptVisitor(this, data);
        }
        return c;
    }

    @Override
    public Condition visit(TestCondition c, BeffyRuleOptimizerDataPassOne data) {
        this.insertNots(data.nestedNots, c);
        return c;
    }
}

