/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes.joinfilter;

import java.io.Serializable;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.ConversionUtils;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Evaluate;
import org.jamocha.engine.nodes.FactTuple;
import org.jamocha.engine.nodes.joinfilter.FieldAddress;
import org.jamocha.engine.nodes.joinfilter.GeneralizedJoinFilter;
import org.jamocha.engine.nodes.joinfilter.JoinFilterException;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;

public class GeneralizedFieldComparator
implements Serializable,
Cloneable,
GeneralizedJoinFilter {
    private static final long serialVersionUID = 1L;
    protected int operator = 9;
    protected String varName = null;
    protected FieldAddress right = null;
    protected FieldAddress left = null;

    public GeneralizedFieldComparator(String varName, FieldAddress fa1, int operator, FieldAddress fa2) {
        this(varName, fa1, fa2);
        this.operator = operator;
    }

    public GeneralizedFieldComparator(String varName, FieldAddress left, FieldAddress right) {
        this.varName = varName;
        this.left = left;
        this.right = right;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public boolean evaluate(FactTuple t, Engine engine) throws JoinFilterException {
        JamochaValue rightValue = null;
        JamochaValue leftValue = null;
        try {
            rightValue = this.right.getIndexedValue(t);
            leftValue = this.left.getIndexedValue(t);
        }
        catch (EvaluationException e) {
            Logging.logger(this.getClass()).warn(e);
        }
        return Evaluate.evaluate(this.operator, leftValue, rightValue);
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String name) {
        this.varName = name;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("?" + this.varName + " ");
        buf.append(this.left.toPPString());
        buf.append(" ");
        buf.append(ConversionUtils.getOperatorDescription(this.operator));
        buf.append(" ");
        buf.append(this.right.toPPString());
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeneralizedFieldComparator) {
            GeneralizedFieldComparator fc = (GeneralizedFieldComparator)obj;
            return this.operator == fc.operator && this.varName.equals(fc.varName) && this.right.equals(fc.right) && this.left.equals(fc.left);
        }
        return false;
    }

    public boolean evaluate(Fact right, FactTuple left, Engine engine) throws JoinFilterException, EvaluationException {
        return this.evaluate(left.appendFact(right), engine);
    }
}

