/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import org.jamocha.application.gui.retevisualisation.NodeDrawer;
import org.jamocha.application.gui.retevisualisation.nodedrawers.ObjectTypeNodeDrawer;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.OneInputNode;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.engine.workingmemory.elements.Deffact;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.JavaFact;
import org.jamocha.engine.workingmemory.elements.JavaTemplate;
import org.jamocha.engine.workingmemory.elements.Template;

public class ObjectTypeNode
extends OneInputNode {
    protected Template template;

    @Deprecated
    private ObjectTypeNode(int id, WorkingMemory memory, ReteNet net) {
        super(id, memory, net);
    }

    @Deprecated
    public ObjectTypeNode(int id, WorkingMemory memory, ReteNet net, Template templ) {
        this(id, memory, net);
        this.template = templ;
    }

    public ObjectTypeNode(Engine e) {
        this(e.getNet().nextNodeId(), e.getWorkingMemory(), e.getNet());
    }

    public ObjectTypeNode(Engine e, Template template) {
        this(e.getNet().nextNodeId(), e.getWorkingMemory(), e.getNet(), template);
    }

    private boolean eval(Fact f) {
        if (this.template instanceof Deftemplate) {
            Logging.logger(this.getClass()).debug("evaluating a " + f.getClass().getSimpleName() + " in a deftemplate situation");
            return f.getTemplate().getName().equals(this.template.getName());
        }
        if (this.template instanceof JavaTemplate) {
            if (f instanceof Deffact) {
                Logging.logger(this.getClass()).debug("evaluating a " + f.getClass().getSimpleName() + " in a javatemplate/deffact situation");
                return f.getTemplate().getName().equals(this.template.getName());
            }
            Logging.logger(this.getClass()).debug("evaluating a " + f.getClass().getSimpleName() + " in a javatemplate/javafact situation");
            Class<?> concrete = ((JavaFact)f).getObject().getClass();
            Class<? extends Object> upper = ((JavaTemplate)this.template).getJavaClass();
            Logging.logger(this.getClass()).debug(upper.getCanonicalName() + " is" + (upper.isAssignableFrom(concrete) ? "" : " not") + " assignable from " + concrete.getCanonicalName());
            return upper.isAssignableFrom(concrete);
        }
        Logging.logger(this.getClass()).debug("evaluating a " + f.getClass().getSimpleName() + " in an unknown situation");
        return false;
    }

    public void addWME(Node sender, WorkingMemoryElement newElem) throws NodeException {
        if (!this.isActivated()) {
            return;
        }
        Template t = newElem.getFirstFact().getTemplate();
        if (this.eval(newElem.getFirstFact())) {
            this.addAndPropagate(newElem);
        }
    }

    public void removeWME(Node sender, WorkingMemoryElement oldElem) throws NodeException {
        Template t = oldElem.getFirstFact().getTemplate();
        if (this.eval(oldElem.getFirstFact())) {
            this.removeAndPropagate(oldElem);
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public boolean outputsBeta() {
        return false;
    }

    protected NodeDrawer newNodeDrawer() {
        return new ObjectTypeNodeDrawer(this);
    }

    public void getDescriptionString(StringBuilder sb) {
        super.getDescriptionString(sb);
        sb.append("|template:").append(this.template.getName());
    }
}

