/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.jamocha.application.gui.retevisualisation.NodeDrawer;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.RootNode;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    protected Node[] childs = new Node[0];
    protected int nodeId;
    protected WorkingMemory workingMemory;
    protected ReteNet net;
    protected NodeDrawer drawer;
    protected boolean activated = false;

    public Node() {
    }

    public int getId() {
        return this.nodeId;
    }

    public boolean isActivated() {
        return this.activated;
    }

    protected void activate2() throws NodeException {
        this.activated = true;
        Logging.logger(this.getClass()).debug("Node " + this.nodeId + " activated");
        for (Node n : this.getChildNodes()) {
            n.activate2();
        }
    }

    protected void activate3() throws NodeException {
        for (Node child : this.getChildNodes()) {
            if (child.isActivated()) {
                for (WorkingMemoryElement wme : this.memory()) {
                    child.addWME(this, wme);
                }
            }
            child.activate3();
        }
    }

    protected void afterActivationHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws NodeException {
        ArrayList<Node> toBeActivated = new ArrayList<Node>();
        Class<RootNode> clazz = RootNode.class;
        synchronized (RootNode.class) {
            LinkedBlockingQueue<Node> queue = new LinkedBlockingQueue<Node>();
            queue.add(this);
            while (!queue.isEmpty()) {
                Node actNode = (Node)queue.poll();
                for (Node child : actNode.getChildNodes()) {
                    queue.add(child);
                    boolean actd = child.isActivated();
                    child.activated = true;
                    if (actd) continue;
                    toBeActivated.add(child);
                    for (WorkingMemoryElement wme : actNode.memory()) {
                        child.addWME(actNode, wme);
                    }
                }
            }
            for (Node child : this.getChildNodes()) {
                boolean act = child.isActivated();
                child.activated = true;
                if (act) continue;
                for (WorkingMemoryElement wme : this.memory()) {
                    child.addWME(this, wme);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (Node child : toBeActivated) {
                child.afterActivationHook();
            }
            return;
        }
    }

    protected void getDescriptionString(StringBuilder sb) {
        sb.append("|id:").append(this.nodeId).append("|");
        sb.append("childs:");
        for (Node child : this.getChildNodes()) {
            sb.append(child.getId()).append(",");
        }
        sb.append("|");
        sb.append("parents:");
        for (Node parent : this.getParentNodes()) {
            sb.append(parent.getId()).append(",");
        }
        int len = this.net.getEngine().getWorkingMemory().size(this);
        sb.append("|elements-in-memory:").append(len);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getClass().getSimpleName());
        this.getDescriptionString(sb);
        sb.append("]\n");
        return sb.toString();
    }

    public void addChild(Node n) throws NodeException {
        Node newChild;
        Node[] newArr = new Node[this.childs.length + 1];
        System.arraycopy(this.childs, 0, newArr, 0, this.childs.length);
        newArr[this.childs.length] = newChild = n.registerParent(this);
        this.childs = newArr;
        for (WorkingMemoryElement wme : this.memory()) {
            newChild.addWME(this, wme);
        }
    }

    public Iterable<WorkingMemoryElement> memory() {
        return this.workingMemory.getMemory(this);
    }

    public Node(int id, WorkingMemory memory, ReteNet net) {
        this();
        this.nodeId = id;
        this.workingMemory = memory;
        this.net = net;
    }

    public abstract Node[] getParentNodes();

    public Node[] getChildNodes() {
        return this.childs;
    }

    public abstract void addWME(Node var1, WorkingMemoryElement var2) throws NodeException;

    public abstract void removeWME(Node var1, WorkingMemoryElement var2) throws NodeException;

    protected void propagateAddition(WorkingMemoryElement elem) throws NodeException {
        for (Node child : this.getChildNodes()) {
            child.addWME(this, elem);
        }
    }

    protected void propagateRemoval(WorkingMemoryElement elem) throws NodeException {
        for (Node child : this.getChildNodes()) {
            child.removeWME(this, elem);
        }
    }

    protected void addAndPropagate(WorkingMemoryElement e) throws NodeException {
        if (this.workingMemory.add(this, e)) {
            this.propagateAddition(e);
        }
    }

    protected void removeAndPropagate(WorkingMemoryElement e) throws NodeException {
        if (this.workingMemory.remove(this, e)) {
            this.propagateRemoval(e);
        }
    }

    public void flush() throws NodeException {
        Iterator<WorkingMemoryElement> i = this.memory().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public NodeDrawer getNodeDrawer() {
        if (this.drawer == null) {
            this.drawer = this.newNodeDrawer();
        }
        return this.drawer;
    }

    protected abstract NodeDrawer newNodeDrawer();

    public abstract boolean outputsBeta();

    protected abstract Node registerParent(Node var1) throws NodeException;

    public void unmount() {
        this.childs = new Node[0];
        this.unbindFromParents();
    }

    protected abstract void unbindFromParents();

    public void removeChild(Node child) {
        int idx = -1;
        for (int i = 0; i < this.childs.length; ++i) {
            if (this.childs[i] != child) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return;
        }
        Node[] newArr = new Node[this.childs.length - 1];
        int j = 0;
        for (int i = 0; i < this.childs.length; ++i) {
            if (i == idx) continue;
            newArr[j++] = this.childs[i];
        }
        this.childs = newArr;
    }
}

