/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jamocha.application.gui.retevisualisation.NodeDrawer;
import org.jamocha.application.gui.retevisualisation.nodedrawers.QuantorBetaFilterNodeDrawer;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.OneInputNode;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaQuantorDistinctionNode
extends OneInputNode {
    private List<Integer> distinctionSlots;
    Map<Key, List<WorkingMemoryElement>> facts;

    private boolean addFact(Key key, WorkingMemoryElement f) {
        List<WorkingMemoryElement> factList = this.facts.get(key);
        if (factList == null) {
            factList = new ArrayList<WorkingMemoryElement>();
            this.facts.put(key, factList);
        }
        int sizeBefore = factList.size();
        factList.add(f);
        return sizeBefore == 0;
    }

    private boolean removeFact(Key key, WorkingMemoryElement f) {
        List<WorkingMemoryElement> factList = this.facts.get(key);
        if (factList == null) {
            return false;
        }
        int sizeBefore = factList.size();
        factList.remove(f);
        return sizeBefore == 1 && factList.size() == 0;
    }

    @Deprecated
    public AlphaQuantorDistinctionNode(int id, WorkingMemory memory, ReteNet net, List<Integer> distinctSlot) {
        super(id, memory, net);
        this.distinctionSlots = distinctSlot;
    }

    public AlphaQuantorDistinctionNode(Engine e, List<Integer> distinctSlot) {
        this(e.getNet().nextNodeId(), e.getWorkingMemory(), e.getNet(), distinctSlot);
    }

    @Override
    public void addWME(Node sender, WorkingMemoryElement newElem) throws NodeException {
        try {
            if (!this.isActivated()) {
                return;
            }
            if (this.addFact(this.key(newElem), newElem)) {
                this.addAndPropagate(newElem);
            }
        }
        catch (EvaluationException e) {
            throw new NodeException(e, (Node)this);
        }
    }

    @Override
    protected NodeDrawer newNodeDrawer() {
        return new QuantorBetaFilterNodeDrawer(this);
    }

    @Override
    public boolean outputsBeta() {
        return false;
    }

    @Override
    public void removeWME(Node sender, WorkingMemoryElement oldElem) throws NodeException {
        try {
            if (!this.isActivated()) {
                return;
            }
            if (this.removeFact(this.key(oldElem), oldElem)) {
                this.removeAndPropagate(oldElem);
            }
        }
        catch (EvaluationException e) {
            throw new NodeException(e, (Node)this);
        }
    }

    private Key key(WorkingMemoryElement oldElem) throws EvaluationException {
        Key key = new Key(new JamochaValue[this.distinctionSlots.size()]);
        for (int i = 0; i < key.v.length; ++i) {
            int slotIdx = this.distinctionSlots.get(i);
            key.v[i] = oldElem.getFirstFact().getSlotValue(slotIdx);
        }
        return key;
    }

    private class Key {
        public JamochaValue[] v;

        public Key(JamochaValue[] v) {
            this.v = v;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.v);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return Arrays.equals(this.v, other.v);
        }

        private AlphaQuantorDistinctionNode getOuterType() {
            return AlphaQuantorDistinctionNode.this;
        }
    }
}

